package com.aote.webmeter.module.kashi;

import com.af.plugins.CommonTools;
import com.af.plugins.DateTools;
import com.af.plugins.RestTools;
import com.af.plugins.iot.WebMeterInfo;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.concurrent.ConcurrentHashMap;

/**
 * 喀什结算工具类
 */
@Transactional(rollbackFor=Exception.class)
@Component
public class KaShiSettlementTools {
    private static Logger log = Logger.getLogger(KaShiSettlementTools.class);
    @Autowired
    private SqlServer sqlServer;

    public void getData() throws Exception {
        WebMeterInfo.setModuleName("KaShi");
        ConcurrentHashMap<String, JSONArray> data = new ConcurrentHashMap<>();
        log.info("查询调价详细信息");
        JSONArray paramArray = sqlServer.query("KaShiGetChangePriceInfo",new JSONObject());
        for(int i = 0; i < paramArray.length();i++){
            JSONObject items = paramArray.getJSONObject(i);
            String meterNumber = items.getString("f_meternumber");
            if(!data.containsKey(meterNumber)){
                data.put(meterNumber,new JSONArray().put(items));
            } else {
                data.get(meterNumber).put(items);
            }
        }
        log.info("查询调价详细信息完成");
        if(DateTools.getNow("yyyy-MM").equals("12-31")){
            log.info("查询跨年异常信息");
            JSONArray priceChangeMeterInfo = sqlServer.query("KaShiGetChangeUsersInfo",new JSONObject());
            for(int i = 0 ;i<priceChangeMeterInfo.length();i++){
                JSONObject items = priceChangeMeterInfo.getJSONObject(i);
                items.put("id",CommonTools.getUUID());
                String meterNumber = items.getString("f_meternumber");
                //如果调价中已有同类信息
                if(data.containsKey(meterNumber)){
                    continue;
                }
                paramArray.put(items);
                data.put(meterNumber,new JSONArray().put(items));
            }
        }
        log.info("放入内存数据库中");
        KaShiInfo.setData(data);
        if(data.size() > 0){
            log.info("调用积成接口");
            String ip = "http://192.168.4.11:18080/ws/rs/getDailyDatas";
            RestTools.post(ip,paramArray.toString());
        }
    }

    public JSONArray settlement(JSONObject obj) {
        ConcurrentHashMap data = KaShiInfo.getData();
        //获取处理数据
        String meterNumber = obj.getString("steal_no");
        if(data.containsKey(meterNumber)){
            JSONArray array = (JSONArray) data.remove(meterNumber);
            for(int i = 0;i < array.length();i++){
                JSONObject priceInfo = array.getJSONObject(i);
                JSONObject params = obj.getJSONObject(priceInfo.getString("begin_date"));
                params.put("steal_no",meterNumber);
                params.put("priceInfo",priceInfo);
                RestTools.post("http://127.0.0.1:8845/webmeter/rs/logic/KaShiHistorySettlement",params);
            }
        }
        JSONObject params = obj.getJSONObject(DateTools.getNow("yyyy-MM-dd"));
        params.put("steal_no",meterNumber);
        return new JSONArray(RestTools.post("http://127.0.0.1:8845/webmeter/rs/logic/KaShiHistorySettlement",params));
    }

    public Boolean checkDataFromKey(String meterNumber) {
        ConcurrentHashMap data = KaShiInfo.getData();
        if(data.containsKey(meterNumber)){
            //调用接口
            String ip = "http://192.168.4.11:18080/ws/rs/getDailyDatas";
            RestTools.post(ip,new JSONArray().put(data.get(meterNumber)).toString());
            return true;
        } else {
            return false;
        }
    }
}
