--异常分析
select * from(
select
{groupname} f_insert_date,sum(zhengchang_usernumber) zhengchang_usernumber,sum(usernumber) usernumber,
AVG(error_bv) error_bv,sum(error_level1) error_level1,AVG(error_level1_bv) error_level1_bv,
sum(error_level2) error_level2,avg(error_level2) error_level2_bv,SUM(error_type1) error_type1,
avg(error_type1_bv) error_type1_bv,sum(error_type2) error_type2,avg(error_type2_bv) error_type2_bv,
SUM(error_type3) error_type3,AVG(error_type3_bv) error_type3_bv,SUM(error_type4) error_type4,
avg(error_type4_bv) error_type4_bv,sum(error_type5) error_type5,avg(error_type5_bv) error_type5_bv,
SUM(error_type6) error_type6,avg(error_type6_bv) error_type6_bv,sum(error_type8) error_type8,
avg(error_type8_bv) error_type8_bv,SUM(error_type9) error_type9,AVG(error_type9_bv) error_type9_bv
from(
	select
	 convert(varchar(4),f_insert_date,23)+'年' year,
	 convert(varchar(7),f_insert_date,23) month,
	 cast(Datename(week,f_insert_date) as varchar)+'周'  week,
	 convert(varchar(50),f_insert_date,23) day,
	 sum(row) row,
	 sum(zhengchang_usernumber) zhengchang_usernumber, --正常户数
	 sum(usernumber) usernumber,	--异常户数
	 Convert(decimal(18,2),(sum(usernumber)/(sum(zhengchang_usernumber)*1.00))*100) error_bv,
	 sum(error_level1) error_level1,	--警告户数
	 Convert(decimal(18,2),(sum(error_level1)/(sum(zhengchang_usernumber)*1.00))*100) error_level1_bv, --警告率
	 sum(error_level2) error_level2,	--错误户数
	 Convert(decimal(18,2),(sum(error_level2)/(sum(zhengchang_usernumber)*1.00))*100) error_level2_bv, --错误率
	 --sum(error_level3) error_level3,	--信息户数
	 sum(error_type1) error_type1,	--抄表异常数
	 Convert(decimal(18,2),(sum(error_type1)/(sum(zhengchang_usernumber)*1.00))*100) error_type1_bv, --抄表异常率
	 sum(error_type2) error_type2,	--电压低数
	 Convert(decimal(18,2),(sum(error_type2)/(sum(zhengchang_usernumber)*1.00))*100) error_type2_bv, --电压低报警率
	 sum(error_type3) error_type3,	--信号质量差数
	 Convert(decimal(18,2),(sum(error_type3)/(sum(zhengchang_usernumber)*1.00))*100) error_type3_bv, --信号质量差报警率
	 sum(error_type4) error_type4,	--磁干扰数
	 Convert(decimal(18,2),(sum(error_type4)/(sum(zhengchang_usernumber)*1.00))*100) error_type4_bv, --磁干扰报警率
	 sum(error_type5) error_type5,	--过流保护关阀数
	 Convert(decimal(18,2),(sum(error_type5)/(sum(zhengchang_usernumber)*1.00))*100) error_type5_bv, --过流保护关阀报警率
	 sum(error_type6) error_type6,	--报警关阀
	 Convert(decimal(18,2),(sum(error_type6)/(sum(zhengchang_usernumber)*1.00))*100) error_type6_bv, --报警关阀率
	 --sum(error_type7) error_type7,	--周期关阀
	 sum(error_type8) error_type8,	--关阀走气
	 Convert(decimal(18,2),(sum(error_type8)/(sum(zhengchang_usernumber)*1.00))*100) error_type8_bv, --关阀走气率
	 sum(error_type9) error_type9,	--拆表报警
	 Convert(decimal(18,2),(sum(error_type9)/(sum(zhengchang_usernumber)*1.00))*100) error_type9_bv --拆表报警率

	from (
			select
				row_number() over(order by every_time) row,
				CONVERT (VARCHAR (11),every_time,23) f_insert_date,
				(select count(*) from t_userfiles uf left join t_userinfo u on uf.f_userinfo_id = u.f_userinfo_id where f_gas_date<=every_time and f_table_state='正常' and {condition}) zhengchang_usernumber,
			   0 usernumber,
			   0 error_level1,
			   0 error_level2,
			   0 error_level3,
			   0 error_type1,
			   0 error_type2,
			   0 error_type3,
			   0 error_type4,
			   0 error_type5,
			   0 error_type6,
			   --0 error_type7,
			   0 error_type8,
			   0 error_type9
			from (
				SELECT
					CONVERT (VARCHAR (100),DATEADD(dd,number,'{startDate}'),23)+' 23:59:59' AS every_time,
					CONVERT (VARCHAR (100),DATEADD(dd,number,'{startDate}'),23)+' 00:00:00' AS every_start_time
				FROM
					master..spt_values n
				WHERE
					n.type = 'p' AND DATEDIFF(MI,DATEADD(dd,number,'{startDate}'),'{endDate}') >= 0
			) s2
			union all
			 select
			   0 row,
			   f_insert_date,
			   0 zhengchang_usernumber,
			   1 usernumber,
			   sum(error_level1) error_level1,
			   sum(error_level2) error_level2,
			   sum(error_level3) error_level3,
			   sum(error_type1) error_type1,
			   sum(error_type2) error_type2,
			   sum(error_type3) error_type3,
			   sum(error_type4) error_type4,
			   sum(error_type5) error_type5,
			   sum(error_type6) error_type6,
			   --sum(error_type7) error_type7,
			   sum(error_type8) error_type8,
			   sum(error_type9) error_type9
			 from(
				select
					e.*,
					case when  f_error_level = '警告' then 1 else 0 end error_level1,
					case when  f_error_level = '错误' then 1 else 0 end error_level2,
					case when  f_error_level = '信息' then 1 else 0 end error_level3,
					case when  f_error_type = '抄表异常' then 1 else 0 end error_type1,
					case when  f_error_type = '电压低' then 1 else 0 end error_type2,
					case when  f_error_type = '信号质量差' then 1 else 0 end error_type3,
					case when  f_error_type = '磁干扰' then 1 else 0 end error_type4,
					case when  f_error_type = '过流保护关阀' then 1 else 0 end error_type5,
					case when  f_error_type = '报警关阀' then 1 else 0 end error_type6,
					--case when  f_error_type = '周期关阀' then 1 else 0 end error_type7,
					case when  f_error_type = '关阀走气' then 1 else 0 end error_type8,
					case when  f_error_type = '拆表报警' then 1 else 0 end error_type9
				from (
					select
						convert(varchar(21),f_insert_date,23) f_insert_date,
						f_user_id,
						f_meternumber,
						f_error_level,
						f_error_type
					from  t_exception
					group by convert(varchar(21),f_insert_date,23),f_meternumber,f_error_level,f_error_type,f_user_id
				) e
				left join t_userfiles uf on e.f_meternumber = uf.f_meternumber and e.f_user_id = uf.f_user_id
				left join t_userinfo u on uf.f_userinfo_id=u.f_userinfo_id
				where f_insert_date>='{startDate}' and f_insert_date<='{endDate}' and {condition}
			) s
			group by s.f_insert_date
	) s group by f_insert_date
) s GROUP BY {groupname}
)s
order by f_insert_date