/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.tcp;

import com.af.plugins.ConvertTools;
import com.aote.logic.LogicServer;
import com.aote.webmeter.server.tcp.TcpServer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.DecoderException;
import org.json.JSONObject;

public class TcpTools {
    private static final ThreadLocal<SocketChannel> CHANNEL_THREAD_LOCAL = new ThreadLocal();
    private static final Map<String, JSONObject> CHANNEL_MESSAGE_MAP = new ConcurrentHashMap<String, JSONObject>();
    private static final ThreadLocal<TcpServer> TCP_SERVER_OBJECT = new ThreadLocal();

    public static void set(SocketChannel channel) {
        CHANNEL_THREAD_LOCAL.set(channel);
    }

    public static void setTcpServerObject(TcpServer server) {
        TCP_SERVER_OBJECT.set(server);
    }

    public static JSONObject getChannelData(SocketChannel channel, String getChannelDataName, JSONObject params, LogicServer service) throws IOException {
        JSONObject channelData;
        String key = channel.getRemoteAddress().toString();
        if (!CHANNEL_MESSAGE_MAP.containsKey(key)) {
            String result = String.valueOf(service.run(getChannelDataName, params));
            if (result != null) {
                channelData = new JSONObject(result);
                CHANNEL_MESSAGE_MAP.put(key, channelData);
            } else {
                channelData = null;
            }
        } else {
            channelData = CHANNEL_MESSAGE_MAP.get(key);
        }
        return channelData;
    }

    public static SocketChannel get() {
        return CHANNEL_THREAD_LOCAL.get();
    }

    public static void send(String message) throws IOException, DecoderException {
        byte[] sendMsgBytes;
        SocketChannel channel = CHANNEL_THREAD_LOCAL.get();
        TcpServer server = TCP_SERVER_OBJECT.get();
        switch (server.msgSendType) {
            default: {
                sendMsgBytes = message.getBytes();
                break;
            }
            case BASE64: {
                sendMsgBytes = ConvertTools.base64Decode((byte[])message.getBytes());
                break;
            }
            case HEX: {
                sendMsgBytes = ConvertTools.hexStrToByte((String)message);
                break;
            }
            case HEX_BASE64: {
                sendMsgBytes = ConvertTools.base64Decode((byte[])ConvertTools.hexStrToByte((String)message));
            }
        }
        ByteBuffer outBuffer = ByteBuffer.wrap(sendMsgBytes);
        channel.write(outBuffer);
    }

    public static void remove() throws IOException {
        SocketChannel channel = CHANNEL_THREAD_LOCAL.get();
        if (channel != null) {
            if (channel.isOpen()) {
                channel.close();
            }
            CHANNEL_THREAD_LOCAL.remove();
        }
    }

    public static void removeTcpServer() {
        TCP_SERVER_OBJECT.remove();
    }
}

