/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.onenet;

import com.af.plugins.HttpConnectionPoolUtil;
import com.af.plugins.RestTools;
import com.aote.webmeter.enums.OnenetApiEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import java.io.IOException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class OnenetRestTools {
    private static final Logger logger = Logger.getLogger(OnenetRestTools.class);

    public static JSONObject createDevice(JSONObject params, String imei, String imsi) throws IOException {
        String path = OnenetApiEnum.DEVICE_URL.getValue();
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        JSONObject authInfo = new JSONObject();
        authInfo.put(imei, (Object)imsi);
        params.put("auth_info", (Object)authInfo);
        return new JSONObject(HttpConnectionPoolUtil.request((String)path, (String)params.toString(), (String)headers.toString(), (HttpRequestBase)new HttpPost()));
    }

    public static JSONObject getDevice(String deviceId) {
        String path = OnenetApiEnum.DEVICE_URL.getValue() + "/" + deviceId;
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        return new JSONObject(RestTools.get((String)path, (JSONObject)headers));
    }

    public static JSONObject deleteDevice(String deviceId) {
        String path = OnenetApiEnum.DEVICE_URL.getValue() + "/" + deviceId;
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        return new JSONObject(RestTools.delete((String)path, null, (JSONObject)headers));
    }

    public static JSONObject readDeviceRes(String imei, String timeout) {
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString("onenetObjectID"));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString("onenetObjectInstID"));
        params.put("res_id", (Object)WebMeterInfo.getString("onenetResID"));
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = RestTools.formatURL((String)OnenetApiEnum.RESOURCE_URL.getValue(), (JSONObject)params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        return new JSONObject(RestTools.get((String)path, (JSONObject)headers));
    }

    public static JSONObject writeDeviceRes(String imei, String mode, String timeout, JSONObject content) throws IOException {
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString("onenetObjectID"));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString("onenetObjectInstID"));
        params.put("mode", mode == null ? Integer.valueOf(1) : mode);
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = RestTools.formatURL((String)OnenetApiEnum.RESOURCE_URL.getValue(), (JSONObject)params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        return new JSONObject(HttpConnectionPoolUtil.request((String)path, (String)content.toString(), (String)headers.toString(), (HttpRequestBase)new HttpPost()));
    }

    public static JSONObject sendCommand(String imei, String timeout, JSONObject content) throws IOException {
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString("onenetObjectID"));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString("onenetObjectInstID"));
        params.put("res_id", (Object)WebMeterInfo.getString("onenetResID"));
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = RestTools.formatURL((String)OnenetApiEnum.COMMAND_URL.getValue(), (JSONObject)params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        long begin = System.currentTimeMillis();
        String result = HttpConnectionPoolUtil.request((String)path, (String)content.toString(), (String)headers.toString(), (HttpRequestBase)new HttpPost());
        long end = System.currentTimeMillis();
        logger.warn((Object)("\u79fb\u52a8\u8bf7\u6c42\u63a5\u53e3\u8017\u65f6\uff1a" + (end - begin) + "ms"));
        return new JSONObject(result);
    }

    public static JSONObject subscribe(JSONObject params) throws IOException {
        String path = RestTools.formatURL((String)OnenetApiEnum.SUBSCRIPTIONS_URL.getValue(), (JSONObject)params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString("onenetAPIKey"));
        String result = HttpConnectionPoolUtil.request((String)path, null, (String)headers.toString(), (HttpRequestBase)new HttpPost());
        return new JSONObject(result);
    }
}

