package com.aote.webmeter.tools.tcp;

import com.af.plugins.ConvertTools;
import com.aote.logic.LogicServer;
import com.aote.webmeter.server.tcp.TcpServer;
import org.apache.commons.codec.DecoderException;
import org.json.JSONObject;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * TCP通讯工具
 */
public class TcpTools {
    /**
     *TCP管道
     */
    private static final ThreadLocal<SocketChannel> CHANNEL_THREAD_LOCAL = new ThreadLocal<>();

    private static final Map<String, JSONObject> CHANNEL_MESSAGE_MAP = new ConcurrentHashMap<>();

    private static final ThreadLocal<TcpServer> TCP_SERVER_OBJECT = new ThreadLocal<>();

    public static void set(SocketChannel channel) {
        CHANNEL_THREAD_LOCAL.set(channel);
    }

    public static void setTcpServerObject(TcpServer server){
        TCP_SERVER_OBJECT.set(server);
    }

    public static JSONObject getChannelData(SocketChannel channel,String getChannelDataName, JSONObject params, LogicServer service) throws IOException {
        JSONObject channelData;
        //如果集合中没有该通道的信息，则调用可以返回通道信息的Logic
        String key = channel.getRemoteAddress().toString();
        if(!CHANNEL_MESSAGE_MAP.containsKey(key)){
            String result = String.valueOf(service.run(getChannelDataName, params));
            if(result != null){
                channelData = new JSONObject(result);
                CHANNEL_MESSAGE_MAP.put(key,channelData);
            } else {
                channelData = null;
            }
        } else {
            channelData = CHANNEL_MESSAGE_MAP.get(key);
        }
        return channelData;
    }

    public static SocketChannel get() {
        return CHANNEL_THREAD_LOCAL.get();
    }

    /**
     * 发送消息
     * @param message 消息体
     * @return 成功
     */
    public static void send(String message) throws IOException, DecoderException {
        SocketChannel channel = CHANNEL_THREAD_LOCAL.get();
        TcpServer server = TCP_SERVER_OBJECT.get();
        byte[] sendMsgBytes;
        ByteBuffer outBuffer;
        switch (server.msgSendType) {
            case NORMAL:
            default:
                sendMsgBytes = message.getBytes();
                break;
            case BASE64:
                sendMsgBytes = ConvertTools.base64Decode(message.getBytes());
                break;
            case HEX:
                sendMsgBytes = ConvertTools.hexStrToByte(message);
                break;
            case HEX_BASE64:
                sendMsgBytes = ConvertTools.base64Decode(ConvertTools.hexStrToByte(message));
                break;
        }
        outBuffer = ByteBuffer.wrap(sendMsgBytes);
        channel.write(outBuffer);
    }

    public static void remove() throws IOException {
        SocketChannel channel = CHANNEL_THREAD_LOCAL.get();
        if(channel != null){
            if(channel.isOpen()){
                channel.close();
            }
            CHANNEL_THREAD_LOCAL.remove();
        }
    }

    public static void removeTcpServer(){
        TCP_SERVER_OBJECT.remove();
    }
}
