package com.aote.webmeter.enums;

/**
 * 物联网表 业务错误码
 *
 * @author Mr.river
 */
public enum BusinessExceptionCodeEnum implements ExceptionEnum {
    //未找到符合条件的档案信息
    USER_FILE_NOT_FIND(
            "B_ERR01",
            "未找到符合条件的档案信息",
            "请检查查询档案的条件"
    ),
    //找到了多条符合条件的档案信息
    USER_FILE_FIND_MULTIPLE(
            "B_ERR02",
            "找到了多条符合条件的档案信息",
            "请检查查询档案的条件"
    ),
    //无效的充值源类型
    INVALID_RECHARGE_SOURCE_TYPE(
            "B_FATAL_1000",
            "判断充值源时遇到无效的充值源信息",
            "请检查生成开户或充值指令时查询的相关数据"
    );

    /**
     * 错误码
     */
    private final String code;
    /**
     * 错误名称
     */
    private final String name;
    /**
     * 错误信息
     */
    private final String message;

    BusinessExceptionCodeEnum(String code, String name, String message) {
        this.code = code;
        this.name = name;
        this.message = message;
    }


    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getMessage() {
        return message;
    }
}
