package com.aote.webmeter.common.template.member.saveInstruct;

import com.aote.sql.SqlServer;
import com.aote.webmeter.common.basic.builder.SaveInstructParamBuilder;
import com.aote.webmeter.common.basic.manage.InstructManage;
import com.aote.webmeter.common.basic.param.SaveInstructParam;
import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.InstructTemplate;
import com.aote.webmeter.common.template.builder.SaveInstructTemplateBuilder;
import com.aote.webmeter.common.template.result.SaveInstructTemplateResult;
import com.aote.webmeter.enums.InstructInputtorEnum;
import com.aote.webmeter.enums.InstructTypeEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import lombok.AccessLevel;
import lombok.Getter;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Getter(AccessLevel.PROTECTED)
@Template
public class SaveInstructTemplate extends InstructTemplate {

    @Autowired
    protected SqlServer sqlServer;
    @Autowired
    protected InstructManage instructManage;

    private final String userId;
    private final InstructTypeEnum type;
    private final String content;
    private final String dataId;
    private final String title;
    private final String alias;
    private final InstructInputtorEnum inputtor;
    private final String moduleName;
    private final JSONObject entity;

    private static final Logger LOGGER = LoggerFactory.getLogger(SaveInstructTemplate.class);

    public SaveInstructTemplate(SaveInstructTemplateBuilder builder){
        this.userId = builder.getUserId();
        this.type = builder.getType();
        this.content = builder.getContent();
        this.dataId = builder.getDataId();
        this.title = builder.getTitle();
        this.alias = builder.getAlias();
        this.inputtor = builder.getInputtor();
        this.moduleName = builder.getModuleName();
        this.entity = builder.getEntity();
    }

    /**
     * 执行模板前操作
     */
    @Override
    public void beforeExec() {
    }

    /**
     * 执行通用保存指令模板
     * @return 保存指令模板执行结果
     */
    @Override
    public SaveInstructTemplateResult exec() throws Exception {
        beforeExec();
        String moduleName = this.moduleName;
        if(moduleName != null){
            //设置模块名
            WebMeterInfo.setModuleName(moduleName);
        }
        LOGGER.info("----------表编号：{}开始通过模板保存指令--------",userId);
        //保存指令
        SaveInstructParamBuilder builder = SaveInstructParamBuilder.create(type,userId);
        SaveInstructParam param = builder
                .setMeterBrandName(alias)
                .setTitle(title)
                .setInputtor(inputtor)
                .setContentData(content)
                .setDataId(dataId)
                .build();
        String instructId = instructManage.save(param);
        LOGGER.info("通过模板保存{}指令成功，ID:{}",type.getValue(),instructId);
        afterExec();
        return new SaveInstructTemplateResult(instructId);
    }

    /**
     * 执行模板后操作
     */
    @Override
    public void afterExec() {
    }
}
