/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.aep;

import com.af.plugins.ConvertTools;
import com.af.plugins.JsonTools;
import com.aote.webmeter.tools.WebMeterInfo;
import com.ctg.ag.sdk.biz.AepDeviceCommandClient;
import com.ctg.ag.sdk.biz.AepDeviceCommandLwmProfileClient;
import com.ctg.ag.sdk.biz.AepDeviceManagementClient;
import com.ctg.ag.sdk.biz.aep_device_command.CreateCommandRequest;
import com.ctg.ag.sdk.biz.aep_device_command_lwm_profile.CreateCommandLwm2mProfileRequest;
import com.ctg.ag.sdk.biz.aep_device_management.CreateDeviceRequest;
import com.ctg.ag.sdk.biz.aep_device_management.DeleteDeviceRequest;
import java.nio.charset.StandardCharsets;
import org.json.JSONObject;

public class AEPTools {
    public static JSONObject getRet(String deviceId, String contentData) throws Exception {
        String appKey = WebMeterInfo.getString("aepAPIKey");
        String appSecret = WebMeterInfo.getString("aepSecret");
        String mastKey = WebMeterInfo.getString("mastKey");
        AepDeviceCommandClient client = (AepDeviceCommandClient)AepDeviceCommandClient.newClient().appKey(appKey).appSecret(appSecret).build();
        CreateCommandRequest request = new CreateCommandRequest();
        request.setParamMasterKey((Object)mastKey);
        request.addParamMasterKey((Object)mastKey);
        JSONObject params = new JSONObject();
        params.put("appId", (Object)appKey);
        params.put("secret", (Object)appSecret);
        params.put("deviceId", (Object)deviceId);
        params.put("operator", (Object)"\u4e1a\u52a1\u7cfb\u7edf");
        params.put("productId", (Object)WebMeterInfo.getString("appId"));
        params.put("ttl", 86400);
        JSONObject content = new JSONObject();
        content.put("dataType", 2);
        content.put("payload", (Object)contentData);
        params.put("content", (Object)content);
        byte[] bytes = ConvertTools.strToBytes((String)params.toString());
        request.setBody(bytes);
        byte[] resultByte = client.CreateCommand(request).getBody();
        client.shutdown();
        return JsonTools.convertToJson((String)new String(resultByte, StandardCharsets.UTF_8));
    }

    public static JSONObject getRetProfile(String deviceId, String contentData, String method, String serviceId) throws Exception {
        String appKey = WebMeterInfo.getString("aepAPIKey");
        String appSecret = WebMeterInfo.getString("aepSecret");
        String mastKey = WebMeterInfo.getString("mastKey");
        AepDeviceCommandLwmProfileClient client = (AepDeviceCommandLwmProfileClient)AepDeviceCommandLwmProfileClient.newClient().appKey(appKey).appSecret(appSecret).build();
        CreateCommandLwm2mProfileRequest request = new CreateCommandLwm2mProfileRequest();
        request.setParamMasterKey((Object)mastKey);
        request.addParamMasterKey((Object)mastKey);
        JSONObject params = new JSONObject();
        params.put("appId", (Object)appKey);
        params.put("secret", (Object)appSecret);
        params.put("deviceId", (Object)deviceId);
        params.put("operator", (Object)"\u4e1a\u52a1\u7cfb\u7edf");
        params.put("productId", (Object)WebMeterInfo.getString("appId"));
        params.put("ttl", 86400);
        JSONObject content = new JSONObject();
        content.put("serviceId", (Object)serviceId);
        content.put("method", (Object)method);
        JSONObject paras = new JSONObject();
        paras.put(method, (Object)contentData);
        content.put("paras", (Object)paras);
        params.put("command", (Object)content);
        byte[] bytes = ConvertTools.strToBytes((String)params.toString());
        request.setBody(bytes);
        byte[] resultByte = client.CreateCommandLwm2mProfile(request).getBody();
        client.shutdown();
        System.out.println(params);
        return JsonTools.convertToJson((String)new String(resultByte, StandardCharsets.UTF_8));
    }

    public static JSONObject getRegister(String imei, String meterNumber) throws Exception {
        String appKey = WebMeterInfo.getString("aepAPIKey");
        String appSecret = WebMeterInfo.getString("aepSecret");
        String mastKey = WebMeterInfo.getString("mastKey");
        AepDeviceManagementClient client = (AepDeviceManagementClient)AepDeviceManagementClient.newClient().appKey(appKey).appSecret(appSecret).build();
        CreateDeviceRequest request = new CreateDeviceRequest();
        request.setParamMasterKey((Object)mastKey);
        request.addParamMasterKey((Object)mastKey);
        JSONObject count = new JSONObject();
        count.put("deviceName", (Object)meterNumber);
        count.put("deviceSn", (Object)meterNumber);
        count.put("imei", (Object)imei);
        count.put("productId", (Object)WebMeterInfo.getString("appId"));
        count.put("operator", (Object)"\u4e1a\u52a1\u7cfb\u7edf");
        JSONObject other = new JSONObject();
        other.put("autoObserver", 0);
        count.put("other", (Object)other);
        byte[] bytes = ConvertTools.strToBytes((String)count.toString());
        request.setBody(bytes);
        byte[] resultByte = client.CreateDevice(request).getBody();
        client.shutdown();
        return JsonTools.convertToJson((String)new String(resultByte, StandardCharsets.UTF_8));
    }

    public static JSONObject getDelete(String deviceId) throws Exception {
        String appKey = WebMeterInfo.getString("aepAPIKey");
        String appSecret = WebMeterInfo.getString("aepSecret");
        String mastKey = WebMeterInfo.getString("mastKey");
        String productId = WebMeterInfo.getString("appId");
        AepDeviceManagementClient client = (AepDeviceManagementClient)AepDeviceManagementClient.newClient().appKey(appKey).appSecret(appSecret).build();
        DeleteDeviceRequest request = new DeleteDeviceRequest();
        request.setParamMasterKey((Object)mastKey);
        request.setParamProductId((Object)productId);
        request.setParamDeviceIds((Object)deviceId);
        byte[] resultByte = client.DeleteDevice(request).getBody();
        client.shutdown();
        return JsonTools.convertToJson((String)new String(resultByte, StandardCharsets.UTF_8));
    }
}

