/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.service;

import com.af.plugins.RestTools;
import com.aote.redis.RedisUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class AlarmStrategyService {
    public JSONArray getExceptionArray(String meterAlias, JSONObject datas) {
        JSONArray result = new JSONArray();
        RedisUtil redisUtil = RedisUtil.getInstance();
        Object strategyStr = redisUtil.get("IOT_SY_" + meterAlias);
        if (strategyStr == null) {
            return result;
        }
        JSONArray strategyArray = new JSONArray(strategyStr);
        for (int i = 0; i < strategyArray.length(); ++i) {
            boolean isException;
            String alarmItem;
            Object value;
            String key;
            JSONObject strategy = strategyArray.getJSONObject(i);
            if (!strategy.has(key = strategy.getString("f_alarm_item")) || (value = datas.opt(alarmItem = strategy.get(key).toString())) == null) continue;
            String errorValue = strategy.getString("f_alarm_value");
            switch (strategy.getInt("f_compare_type")) {
                case 1: {
                    isException = value.equals(errorValue);
                    break;
                }
                case 2: {
                    isException = !value.equals(errorValue);
                    break;
                }
                case 3: {
                    isException = Double.doubleToLongBits(Double.parseDouble(value.toString())) > Double.doubleToLongBits(Double.parseDouble(errorValue));
                    break;
                }
                case 4: {
                    isException = Double.doubleToLongBits(Double.parseDouble(value.toString())) < Double.doubleToLongBits(Double.parseDouble(errorValue));
                    break;
                }
                default: {
                    isException = false;
                }
            }
            if (!isException) continue;
            JSONObject param = new JSONObject();
            param.put("f_strategy_id", strategy.get("id"));
            param.put("f_alarm_state", 0);
            String msg = strategy.getString("f_alarm_msg");
            if (strategy.has("f_alarm_variable")) {
                msg = this.format(msg, value.toString(), datas, strategy.getJSONArray("f_alarm_variable"));
            }
            param.put("f_error_msg", (Object)msg);
            int pushType = strategy.optInt("f_push_type", -1);
            if (pushType == 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("userFilesId", (Object)datas.getString("f_userfiles_id"));
                jsonObject.put("value", (Object)msg);
                RestTools.post((String)strategy.getString("f_push_url"), (JSONObject)jsonObject);
            }
            result.put((Object)param);
        }
        return result;
    }

    private String format(String regex, String alarmItemValue, JSONObject params, JSONArray paramsIndex) {
        regex = regex.replaceAll("\\{0}", alarmItemValue);
        for (int i = 1; i <= paramsIndex.length(); ++i) {
            String key = paramsIndex.getString(i - 1);
            String value = params.optString(key, "-");
            regex = regex.replaceAll("\\{" + i + "}", String.valueOf(value));
        }
        return regex;
    }
}

