package com.aote.webmeter.service;

import com.af.plugins.RestTools;
import com.aote.redis.RedisUtil;
import com.aote.webmeter.mapper.AlarmStrategyMapper;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 * 物联网告警策略服务
 *
 * @author Mrriver
 * @date 2023/2/14
 */
public class AlarmStrategyService {
    /**
     * 获取异常列表
     *
     * @param meterAlias 表具别名
     * @param datas 抄表数据
     * @return 业务逻辑名
     */
    public JSONArray getExceptionArray(String meterAlias, JSONObject datas) {
        JSONArray result = new JSONArray();
        RedisUtil redisUtil = RedisUtil.getInstance();
        Object strategyStr = redisUtil.get(AlarmStrategyMapper.ALARM_STRATEGY_PREFIX + meterAlias);
        if(strategyStr == null){
            return result;
        }
        JSONArray strategyArray = new JSONArray(strategyStr);
        for (int i = 0; i < strategyArray.length(); i++) {
            JSONObject strategy = strategyArray.getJSONObject(i);
            String key = strategy.getString("f_alarm_item");
            if (strategy.has(key)) {
                String alarmItem = strategy.get(key).toString();
                Object value = datas.opt(alarmItem);
                if (value != null) {
                    //异常阈值
                    String errorValue = strategy.getString("f_alarm_value");
                    //异常结果值
                    boolean isException;
                    switch (strategy.getInt("f_compare_type")) {
                        case 1:
                            isException = value.equals(errorValue);
                            break;
                        case 2:
                            isException = !value.equals(errorValue);
                            break;
                        case 3:
                            isException = Double.doubleToLongBits(Double.parseDouble(value.toString())) >
                                    Double.doubleToLongBits(Double.parseDouble(errorValue));
                            break;
                        case 4:
                            isException = Double.doubleToLongBits(Double.parseDouble(value.toString())) <
                                    Double.doubleToLongBits(Double.parseDouble(errorValue));
                            break;
                        default:
                            isException = false;
                            break;
                    }
                    if (isException) {
                        JSONObject param = new JSONObject();
                        param.put("f_strategy_id", strategy.get("id"));
                        param.put("f_alarm_state", 0);
                        String msg = strategy.getString("f_alarm_msg");
                        if (strategy.has("f_alarm_variable")) {
                            msg = format(msg, value.toString(), datas, strategy.getJSONArray("f_alarm_variable"));
                        }
                        param.put("f_error_msg", msg);
                        int pushType = strategy.optInt("f_push_type", -1);
                        if(pushType == 0){
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("userFilesId", datas.getString("f_userfiles_id"));
                            jsonObject.put("value", msg);
                            RestTools.post(strategy.getString("f_push_url"), jsonObject);
                        }
                        result.put(param);
                    }
                }
            }
        }
        return result;
    }

    private String format(String regex, String alarmItemValue, JSONObject params, JSONArray paramsIndex) {
        regex = regex.replaceAll("\\{0}", alarmItemValue);
        for (int i = 1; i <= paramsIndex.length(); i++) {
            String key = paramsIndex.getString(i - 1);
            Object value = params.optString(key, "-");
            regex = regex.replaceAll("\\{" + i + "}", String.valueOf(value));
        }
        return regex;
    }
}
