package com.aote.webmeter.mapper;

import com.af.plugins.RestTools;
import com.aote.queryparams.QueryParamsServer;
import com.aote.redis.RedisUtil;
import com.aote.rs.SqlService;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * 物联网告警策略映射器
 *
 * @author Mrriver
 * @date 2023/2/14
 */
@Component
public class AlarmStrategyMapper {
    private static final Logger LOGGER = Logger.getLogger(AlarmStrategyMapper.class);

    public static final String IS_LOADED_KEY = "ALARM_STRATEGY_IS_LOADED";
    public static final String NO_LOAD_FLAG = "0";
    public static final String LOADED_FLOG = "1";
    public static final String ALARM_STRATEGY_PREFIX = "IOT_SY_";
    private static final String QUERY_SQL = "SELECT * FROM t_iot_device_alarm_strategy WHERE f_state = 1 ORDER BY f_alarm_alias";

    @Autowired
    private SqlService sqlService;

    @PostConstruct
    public void load() {
        RedisUtil redisUtil = RedisUtil.getInstance();
        if(redisUtil != null){
            redisUtil.lock(IS_LOADED_KEY, ()->{
                Object isLoaded = redisUtil.get(IS_LOADED_KEY);
                if(isLoaded == null || NO_LOAD_FLAG.equals(isLoaded)){
                    JSONArray result = null;
                    try {
                        result = new JSONArray(sqlService.txQuery(QUERY_SQL));
                    } catch (Exception e) {
                        LOGGER.warn("物联网告警策略(t_iot_device_alarm_strategy)查询失败，不再加载告警策略配置");
                    }
                    if(result != null) {
                        for (Object o : result) {
                            JSONObject item = (JSONObject) o;
                            String key = ALARM_STRATEGY_PREFIX + item.getString("f_alarm_alias");
                            Object value = redisUtil.get(key);
                            JSONArray valueArray;
                            if(value != null){
                                valueArray = new JSONArray(value);
                            } else {
                                valueArray = new JSONArray();
                            }
                            valueArray.put(item);
                            redisUtil.set(key, valueArray);
                        }
                        //修改加载标识
                        redisUtil.set(IS_LOADED_KEY, LOADED_FLOG);
                        LOGGER.debug("物联网告警策略预加载完成");
                    }
                } else {
                    LOGGER.debug("跳过加载物联网告警策略表");
                }
            });
        }
    }
}
