/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import com.af.plugins.JsonTools;
import com.aote.webmeter.tools.ByteTool;
import java.math.BigDecimal;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteDataBuffer {
    private static final Logger log = LoggerFactory.getLogger(ByteDataBuffer.class);
    private static int INCREASE_DATA_SIZE = 256;
    private boolean inBigEndian;
    private byte[] dataBuffer;
    private int pos;
    private int dataSize;
    private String encoding;
    private char defaultFillChar;

    public ByteDataBuffer() {
        this(INCREASE_DATA_SIZE);
    }

    public ByteDataBuffer(int size) {
        this.inBigEndian = false;
        this.pos = 0;
        this.dataBuffer = new byte[size];
        this.dataSize = 0;
    }

    public ByteDataBuffer(byte[] data) {
        this(data, false);
    }

    public ByteDataBuffer(byte[] data, boolean inBigEndian) {
        this.inBigEndian = inBigEndian;
        this.pos = 0;
        if (data != null) {
            this.dataBuffer = data;
            this.dataSize = data.length;
        } else {
            this.dataBuffer = new byte[INCREASE_DATA_SIZE];
            this.dataSize = 0;
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (this.dataBuffer.length < minCapacity) {
            int nextBufSize = INCREASE_DATA_SIZE * (minCapacity / INCREASE_DATA_SIZE + 1);
            byte[] data = new byte[nextBufSize];
            System.arraycopy(this.dataBuffer, 0, data, 0, this.dataBuffer.length);
            this.dataBuffer = data;
        }
    }

    public byte[] getBytes() {
        byte[] data = new byte[this.getDataSize()];
        System.arraycopy(this.dataBuffer, 0, data, 0, data.length);
        return data;
    }

    public int getDataSize() {
        if (this.pos > this.dataSize) {
            this.dataSize = this.pos;
        }
        return this.dataSize;
    }

    public byte readInt8() {
        byte result = this.dataBuffer[this.pos];
        ++this.pos;
        return result;
    }

    public short readInt16() {
        short word0 = this.inBigEndian ? (short)(((this.dataBuffer[this.pos] & 0xFF) << 8) + (this.dataBuffer[this.pos + 1] & 0xFF)) : (short)((this.dataBuffer[this.pos] & 0xFF) + ((this.dataBuffer[this.pos + 1] & 0xFF) << 8));
        this.pos += 2;
        return word0;
    }

    public int readInt24() {
        int i = this.inBigEndian ? ((this.dataBuffer[this.pos] & 0xFF) << 24) + ((this.dataBuffer[this.pos + 1] & 0xFF) << 16) + ((this.dataBuffer[this.pos + 2] & 0xFF) << 8) : (this.dataBuffer[this.pos] & 0xFF) + ((this.dataBuffer[this.pos + 1] & 0xFF) << 8) + ((this.dataBuffer[this.pos + 2] & 0xFF) << 16);
        this.pos += 3;
        return i;
    }

    public int readInt32() {
        int i = this.inBigEndian ? ((this.dataBuffer[this.pos] & 0xFF) << 24) + ((this.dataBuffer[this.pos + 1] & 0xFF) << 16) + ((this.dataBuffer[this.pos + 2] & 0xFF) << 8) + (this.dataBuffer[this.pos + 3] & 0xFF) : (this.dataBuffer[this.pos] & 0xFF) + ((this.dataBuffer[this.pos + 1] & 0xFF) << 8) + ((this.dataBuffer[this.pos + 2] & 0xFF) << 16) + ((this.dataBuffer[this.pos + 3] & 0xFF) << 24);
        this.pos += 4;
        return i;
    }

    public int readBytes(byte[] data) {
        return this.readBytes(data, 0, data.length);
    }

    public int readBytes(byte[] data, int destPos, int length) {
        if (length > this.dataBuffer.length - this.pos) {
            length = this.dataBuffer.length - this.pos;
        }
        if (length > 0) {
            System.arraycopy(this.dataBuffer, this.pos, data, destPos, length);
        }
        this.pos += length;
        return length;
    }

    public JSONObject commonParse(JSONObject config) throws Exception {
        if (!config.has("name")) {
            throw new Exception("\u7f3a\u5c11\u5b57\u6bb5\u540d, \u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        if (!config.has("length")) {
            throw new Exception("\u7f3a\u5c11\u5b57\u6bb5\u957f\u5ea6, \u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        if (!config.has("type")) {
            throw new Exception("\u7f3a\u5c11\u5b57\u6bb5\u7c7b\u578b, \u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        JSONObject jsonObject = new JSONObject();
        String type = config.getString("type");
        int length = config.getInt("length");
        Object value = null;
        if ("Number".equals(type)) {
            value = this.commonReadNumber(length);
        } else if ("String".equals(type)) {
            value = this.commonReadStr(length);
            if (config.has("transConfigPath")) {
                ByteDataBuffer str = new ByteDataBuffer(ByteTool.hexString2Bytes((String)value));
                value = str.parse(JsonTools.readJsonArrayFile((String)config.getString("transConfigPath")));
            }
        } else if ("Array".equals(type)) {
            value = this.commonReadArray(config);
        }
        if (config.has("children")) {
            value = this.commonReadBit((Integer)value, config.getJSONArray("children"));
        }
        if (config.has("magnification")) {
            BigDecimal bigDecimal = new BigDecimal((Integer)value);
            value = bigDecimal.divide(new BigDecimal(config.getInt("magnification")));
        }
        jsonObject.put("key", (Object)config.getString("name"));
        jsonObject.put("value", value);
        return jsonObject;
    }

    public JSONArray commonReadArray(JSONObject config) {
        int length = config.getInt("length");
        int nodeLength = config.getInt("nodeLength");
        String nodeType = config.getString("nodeType");
        String nodeTransParsePath = config.getString("nodeTransConfigPath");
        int nodeMagnification = config.optInt("nodeMagnification");
        JSONArray array = new JSONArray();
        if ("Number".equals(nodeType)) {
            for (int i = 0; i < length / nodeLength; ++i) {
                int i1 = this.commonReadNumber(nodeLength);
                if (nodeMagnification != 0) {
                    array.put((Object)new BigDecimal(i1).divide(new BigDecimal(nodeMagnification)));
                    continue;
                }
                array.put(i1);
            }
        } else {
            for (int i = 0; i < length / nodeLength; ++i) {
                JSONObject jsonObject = this.parse(JsonTools.readJsonArrayFile((String)nodeTransParsePath));
                array.put((Object)jsonObject);
            }
        }
        return array;
    }

    public String commonReadStr(int length) {
        byte[] str = new byte[length];
        int i = this.readBytes(str);
        log.debug("\u8bfb\u53d6{}\u5b57\u8282\u6570\u636e", (Object)i);
        return ByteTool.bytesToHexString(str);
    }

    public int commonReadNumber(int length) {
        if (length == 1) {
            return this.readInt8();
        }
        if (length == 2) {
            return this.readInt16();
        }
        if (length == 3) {
            return this.readInt24();
        }
        if (length == 4) {
            return this.readInt32();
        }
        return Integer.MAX_VALUE;
    }

    public Object commonReadBit(int data, JSONArray children) {
        JSONObject childResult = new JSONObject();
        for (int i = 0; i < children.length(); ++i) {
            JSONObject childConfig = (JSONObject)children.get(i);
            int bitData = data & Integer.parseInt(childConfig.getString("value"), 2);
            if (!childConfig.optBoolean("shift")) {
                bitData >>>= Integer.toBinaryString(Integer.parseInt(childConfig.getString("value"), 2)).length() - 1;
            }
            childResult.put(childConfig.getString("name"), bitData);
        }
        return childResult;
    }

    public JSONObject parse(JSONArray configs) {
        JSONObject result = new JSONObject();
        for (int i = 0; i < configs.length(); ++i) {
            JSONObject config = configs.getJSONObject(i);
            try {
                JSONObject jsonObject = this.commonParse(config);
                result.put(jsonObject.getString("key"), jsonObject.get("value"));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public JSONObject dataTrans(String filePath) {
        return this.parse(JsonTools.readJsonArrayFile((String)filePath));
    }

    public void writeInt8(byte data) {
        this.ensureCapacity(this.pos + 1);
        this.dataBuffer[this.pos] = data;
        ++this.pos;
    }

    public void writeInt16(int i) {
        this.ensureCapacity(this.pos + 2);
        if (this.inBigEndian) {
            this.dataBuffer[this.pos] = (byte)(i >>> 8 & 0xFF);
            this.dataBuffer[this.pos + 1] = (byte)(i & 0xFF);
        } else {
            this.dataBuffer[this.pos] = (byte)(i & 0xFF);
            this.dataBuffer[this.pos + 1] = (byte)(i >>> 8 & 0xFF);
        }
        this.pos += 2;
    }

    public void writeInt24(int i) {
        this.ensureCapacity(this.pos + 2);
        if (this.inBigEndian) {
            this.dataBuffer[this.pos] = (byte)(i >>> 16 & 0xFF);
            this.dataBuffer[this.pos + 1] = (byte)(i >>> 8 & 0xFF);
            this.dataBuffer[this.pos + 2] = (byte)(i & 0xFF);
        } else {
            this.dataBuffer[this.pos] = (byte)(i & 0xFF);
            this.dataBuffer[this.pos + 1] = (byte)(i >>> 8 & 0xFF);
            this.dataBuffer[this.pos + 2] = (byte)(i >>> 16 & 0xFF);
        }
        this.pos += 3;
    }

    public void writeInt32(int i) {
        this.ensureCapacity(this.pos + 4);
        if (this.inBigEndian) {
            this.dataBuffer[this.pos] = (byte)(i >>> 24 & 0xFF);
            this.dataBuffer[this.pos + 1] = (byte)(i >>> 16 & 0xFF);
            this.dataBuffer[this.pos + 2] = (byte)(i >>> 8 & 0xFF);
            this.dataBuffer[this.pos + 3] = (byte)(i & 0xFF);
        } else {
            this.dataBuffer[this.pos] = (byte)(i & 0xFF);
            this.dataBuffer[this.pos + 1] = (byte)(i >>> 8 & 0xFF);
            this.dataBuffer[this.pos + 2] = (byte)(i >>> 16 & 0xFF);
            this.dataBuffer[this.pos + 3] = (byte)(i >>> 24 & 0xFF);
        }
        this.pos += 4;
    }

    public void writeBytes(byte[] data) {
        this.writeBytes(data, 0, data.length);
    }

    public void writeBytes(byte[] data, int srcPos, int length) {
        if (data == null || length <= 0) {
            return;
        }
        if (srcPos + length > data.length) {
            length = data.length - srcPos;
        }
        this.ensureCapacity(this.pos + length);
        System.arraycopy(data, srcPos, this.dataBuffer, this.pos, length);
        this.pos += length;
    }

    public void writeFillerBytes(byte data, int length) {
        this.ensureCapacity(this.pos + length);
        for (int j = 0; j < length; ++j) {
            this.dataBuffer[this.pos] = data;
            ++this.pos;
        }
    }

    public static void main(String[] args) {
        JSONArray array = JsonTools.readJsonArrayFile((String)"dataBuffer/QinChuanNB21/1003.json");
        System.out.println(array.toString());
    }
}

