/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.timer;

import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import com.aote.webmeter.enums.DataSourceTypeEnum;
import com.aote.webmeter.tools.CompatTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Profile(value={"prod"})
public class InstructSyncTimer {
    private static final Logger LOG_MANAGER = LogManager.getLogger(InstructSyncTimer.class);
    @Autowired
    EntityServer entityServer;
    @Autowired
    private SqlServer sqlServer;

    @Scheduled(cron="0 5 9,15,21 * * ?")
    @Transactional
    public void runDataSync() {
        LOG_MANAGER.info("=====\u5f00\u59cb\u8fc1\u79fb\u5386\u53f2\u6307\u4ee4=====");
        String instructTableName = CompatTools.getInstructTableName();
        DataSourceTypeEnum dataSourceTypeEnum = WebMeterInfo.getDataSourceTypeEnum();
        String searchSQL = "SELECT * FROM " + instructTableName + " WHERE f_instruct_state IN ('\u6267\u884c\u6210\u529f', '\u6267\u884c\u5931\u8d25', '\u5ffd\u7565\u5197\u4f59', '\u65e0\u54cd\u5e94') OR (f_instruct_state = '\u54cd\u5e94\u8d85\u65f6' AND f_inputtor IN ('\u7cfb\u7edf\u751f\u6210','\u7cfb\u7edf\u6863\u6848\u6d41\u7a0b'))";
        if (dataSourceTypeEnum == DataSourceTypeEnum.ORACLE) {
            this.sqlServer.runSQL("CREATE GLOBAL TEMPORARY TABLE temp_history_instruct AS ( " + searchSQL + " )");
            this.sqlServer.runSQL("INSERT INTO t_instruct_history SELECT * FROM temp_history_instruct");
            this.sqlServer.runSQL("DELETE FROM " + instructTableName + " WHERE id IN ( SELECT id FROM temp_history_instruct)");
            this.sqlServer.runSQL("DROP TABLE temp_history_instruct");
        } else if (dataSourceTypeEnum == DataSourceTypeEnum.SQLSERVER) {
            this.sqlServer.runSQL("SELECT * INTO ##temp_history_instruct FROM ( " + searchSQL + " ) a");
            this.sqlServer.runSQL("INSERT INTO t_instruct_history SELECT * FROM ##temp_history_instruct");
            this.sqlServer.runSQL("DELETE FROM " + instructTableName + " WHERE id IN ( SELECT id FROM ##temp_history_instruct)");
            this.sqlServer.runSQL("DROP TABLE ##temp_history_instruct");
        } else {
            this.sqlServer.runSQL("CREATE TEMPORARY TABLE temp_history_instruct " + searchSQL);
            this.sqlServer.runSQL("INSERT INTO t_instruct_history SELECT * FROM temp_history_instruct");
            this.sqlServer.runSQL("DELETE FROM " + instructTableName + " WHERE id IN ( SELECT id FROM temp_history_instruct)");
            this.sqlServer.runSQL("DROP TEMPORARY TABLE temp_history_instruct");
        }
        LOG_MANAGER.info("=====\u5386\u53f2\u6307\u4ee4\u8fc1\u79fb\u6267\u884c\u5b8c\u6210=====");
    }
}

