/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.mapper;

import com.aote.redis.RedisUtil;
import com.aote.rs.SqlService;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlarmStrategyMapper {
    private static final Logger LOGGER = Logger.getLogger(AlarmStrategyMapper.class);
    public static final String IS_LOADED_KEY = "ALARM_STRATEGY_IS_LOADED";
    public static final String NO_LOAD_FLAG = "0";
    public static final String LOADED_FLOG = "1";
    public static final String ALARM_STRATEGY_PREFIX = "IOT_SY_";
    private static final String QUERY_SQL = "SELECT * FROM t_iot_device_alarm_strategy WHERE f_state = 1 ORDER BY f_alarm_alias";
    @Autowired
    private SqlService sqlService;

    @PostConstruct
    public void load() {
        RedisUtil redisUtil = RedisUtil.getInstance();
        if (redisUtil != null) {
            redisUtil.lock(IS_LOADED_KEY, () -> {
                Object isLoaded = redisUtil.get(IS_LOADED_KEY);
                if (isLoaded == null || NO_LOAD_FLAG.equals(isLoaded)) {
                    JSONArray result = null;
                    try {
                        result = new JSONArray(this.sqlService.txQuery(QUERY_SQL));
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)"\u7269\u8054\u7f51\u544a\u8b66\u7b56\u7565(t_iot_device_alarm_strategy)\u67e5\u8be2\u5931\u8d25\uff0c\u4e0d\u518d\u52a0\u8f7d\u544a\u8b66\u7b56\u7565\u914d\u7f6e");
                    }
                    if (result != null) {
                        for (Object o : result) {
                            JSONObject item = (JSONObject)o;
                            String key = ALARM_STRATEGY_PREFIX + item.getString("f_alarm_alias");
                            Object value = redisUtil.get(key);
                            JSONArray valueArray = value != null ? new JSONArray(value) : new JSONArray();
                            valueArray.put((Object)item);
                            redisUtil.set(key, (Object)valueArray);
                        }
                        redisUtil.set(IS_LOADED_KEY, (Object)LOADED_FLOG);
                        LOGGER.debug((Object)"\u7269\u8054\u7f51\u544a\u8b66\u7b56\u7565\u9884\u52a0\u8f7d\u5b8c\u6210");
                    }
                } else {
                    LOGGER.debug((Object)"\u8df3\u8fc7\u52a0\u8f7d\u7269\u8054\u7f51\u544a\u8b66\u7b56\u7565\u8868");
                }
            });
        }
    }
}

