package com.aote.webmeter.enums;

/**
 * 物联网表 通用错误码
 *
 * @author Mr.river
 */
public enum WebmeterExceptionCodeEnum implements ExceptionEnum {
    //物联网表配置文件异常
    CONFIG_FAIL(
            "ERR01",
            "获取物联网表模块配置文件失败",
            "请检查模块下是否包含webmeter.properties配置文件"
    ),
    //未找到物联网表模块异常
    MODULE_NOT_FIND_FAIL(
            "ERR02",
            "未找到此物联网表模块",
            "请检查物联网表模块名是否配置正确"
    ),
    //未找到对应营收版本异常
    SALE_VERSION_NOT_FIND_FAIL(
            "ERR03",
            "未找到此营收版本",
            "请检查webmeter/webmeter.properties配置文件中营收版本是否配置正确"
    ),
    //营收版本未配置异常
    SALE_VERSION_NULL_FAIL(
            "ERR04",
            "营收版本未配置",
            "请配置webmeter/webmeter.properties配置文件中的营收版本参数"
    ),
    //未找到对应数据源类型异常
    DATA_SOURCE_TYPE_NOT_FIND_FAIL(
            "ERR05",
            "未找到此数据源类型",
            "请检查webmeter/webmeter.properties配置文件中数据源类型是否配置正确"
    ),
    //数据源类型未配置异常
    DATA_SOURCE_TYPE_NULL_FAIL(
            "ERR06",
            "数据源类型未配置",
            "请配置webmeter/webmeter.properties配置文件中的数据源类型参数"
    );

    /**
     * 错误码
     */
    private final String code;
    /**
     * 错误名称
     */
    private final String name;
    /**
     * 错误信息
     */
    private final String message;

    WebmeterExceptionCodeEnum(String code, String name, String message) {
        this.code = code;
        this.name = name;
        this.message = message;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getMessage() {
        return message;
    }
}
