/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot;

import com.af.plugins.HttpDeleteWithBody;
import com.aote.webmeter.enums.IOTBusinessTypeEnum;
import com.aote.webmeter.enums.WebmeterPropertiesIOTEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.IotCommonTools;
import com.aote.webmeter.tools.iot.aep.AEPTools;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class DeviceManagementTools {
    private static final Logger LOGGER = Logger.getLogger(DeviceManagementTools.class);
    private static final String DEVICE_BINDED_1 = "100416";
    private static final String DEVICE_BINDED_2 = "100426";
    private static final String DEVICE_BINDED_3 = "1104";
    private static final String DEVICE_CANCEL_BINDED_1 = "100403";
    private static final String DEVICE_CANCEL_BINDED_2 = "100418";

    public static JSONObject regDevice(String nodeId, String name) {
        JSONObject content = new JSONObject();
        content.put("nodeId", (Object)nodeId);
        content.put("verifyCode", (Object)nodeId);
        content.put("timeout", 0);
        content.put("deviceName", (Object)name);
        JSONObject deviceInfo = new JSONObject();
        DeviceManagementTools.getDeviceInfo(deviceInfo);
        content.put("deviceInfo", (Object)deviceInfo);
        JSONObject result = new JSONObject();
        String includeOC = WebMeterInfo.getString("isNativeAep", "0");
        if (includeOC.equals("1")) {
            JSONObject resultData = AEPTools.getRegister(nodeId, name);
            if (resultData.getInt("code") == 0) {
                result.put("code", 0).put("msg", (Object)resultData.getJSONObject("result").getString("deviceId"));
            } else {
                result.put("code", -1).put("msg", (Object)resultData.getString("msg"));
            }
            return result;
        }
        JSONObject resultData = IotCommonTools.post(IOTBusinessTypeEnum.CREATE_DEVICE, (HttpEntityEnclosingRequestBase)new HttpPost(), content);
        if (resultData.has("errorEntity")) {
            JSONObject errorEntity = new JSONObject(resultData.getString("errorEntity"));
            String errorKey = errorEntity.get("error_code").toString();
            if (DEVICE_BINDED_1.equals(errorKey) || DEVICE_BINDED_2.equals(errorKey) || DEVICE_BINDED_3.equals(errorKey)) {
                result.put("code", -1).put("msg", (Object)"\u5c1d\u8bd5\u6ce8\u518c\u65f6\u5df2\u7ed1\u5b9a");
            } else {
                result.put("code", -1).put("msg", (Object)("\u6ce8\u518cIOT\u8bbe\u5907\u5931\u8d25\uff1a" + errorEntity));
            }
        } else {
            result.put("code", 0).put("msg", (Object)resultData.getString("deviceId"));
        }
        return result;
    }

    public static JSONObject modifyDeviceInfo(String deviceId, String name) {
        JSONObject content = new JSONObject();
        content.put("name", (Object)name);
        DeviceManagementTools.getDeviceInfo(content);
        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.MODIFY_DEVICE, (HttpEntityEnclosingRequestBase)new HttpPut(), content, deviceId);
        if (result.has("errorEntity")) {
            JSONObject errorEntity = new JSONObject(result.getString("errorEntity"));
            return new JSONObject().put("code", -1).put("msg", (Object)("\u4fee\u6539IOT\u8bbe\u5907\u5931\u8d25\uff1a" + errorEntity));
        }
        return new JSONObject().put("code", 0).put("msg", (Object)"\u6210\u529f");
    }

    private static void getDeviceInfo(JSONObject content) {
        content.put("manufacturerId", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.MANUFACTURER_ID));
        content.put("manufacturerName", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.MANUFACTURER_NAME));
        content.put("deviceType", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.DEVICE_TYPE));
        content.put("model", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.METER_MODEL));
        content.put("protocolType", (Object)"CoAP");
    }

    public static JSONObject cancelDevice(String deviceId) {
        JSONObject result = new JSONObject();
        String includeOC = WebMeterInfo.getString("isNativeAep", "0");
        if (includeOC.equals("1")) {
            JSONObject resultData = AEPTools.getDelete(deviceId);
            if (resultData.getInt("code") == 0) {
                result.put("code", 0).put("msg", (Object)"\u6210\u529f");
            } else {
                result.put("code", -1).put("msg", (Object)resultData.getString("msg"));
            }
        } else {
            JSONObject resultData = IotCommonTools.post(IOTBusinessTypeEnum.MODIFY_DEVICE, (HttpEntityEnclosingRequestBase)new HttpDeleteWithBody(), null, deviceId);
            if (resultData.has("errorEntity")) {
                JSONObject errorEntity = new JSONObject(resultData.getString("errorEntity"));
                String code = errorEntity.get("error_code").toString();
                if (DEVICE_CANCEL_BINDED_1.equals(code) || DEVICE_CANCEL_BINDED_2.equals(code)) {
                    result.put("code", 0).put("msg", (Object)"\u5c1d\u8bd5\u5220\u9664\u65f6\u5df2\u4e0d\u5b58\u5728");
                }
                result.put("code", -1).put("msg", (Object)("\u5220\u9664IOT\u8bbe\u5907\u5931\u8d25\uff1a" + errorEntity));
            } else {
                result.put("code", 0).put("msg", (Object)"\u6210\u529f");
            }
        }
        return result;
    }
}

