package com.aote.webmeter.tools;

import com.af.plugins.JsonTools;
import com.af.plugins.RestTools;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * 物联网表抄表异常记录映射配置工具（V1.2）
 * 报警映射配置：mainExceptions.json
 *
 * @author Mrriver
 * @date 2020/6/18
 */
public class GetExceptionsTools {
    private static final Logger LOGGER = Logger.getLogger(GetExceptionsTools.class);
    /**
     * 报警映射配置路径
     */
    private static final String CONFIG_URL = "webmeter/mainExceptions.json";
    /**
     * 异常映射列表
     */
    private static final JSONArray EXCEPTION_LIST;

    static {
        //加载异常映射
        if (GetInstructsTools.class.getClassLoader().getResourceAsStream(CONFIG_URL) != null) {
            EXCEPTION_LIST = JsonTools.readJsonArrayFile(CONFIG_URL);
            LOGGER.debug("加载抄表异常记录映射配置文件完成");
        } else {
            throw new RuntimeException("缺少抄表异常记录映射配置文件：mainExceptions.json");
        }
    }

    /**
     * 获取异常列表
     *
     * @param params 校验参数集
     * @return 业务逻辑名
     */
    public JSONArray getExceptionArray(JSONObject params) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < EXCEPTION_LIST.length(); i++) {
            JSONObject exception = EXCEPTION_LIST.getJSONObject(i);
            String key = exception.getString("key");
            if (params.has(key)) {
                Object object = params.get(key);
                if (object != null) {
                    double value;
                    //上报的值
                    try {
                        value = params.getDouble(key);
                    } catch (JSONException e) {
                        continue;
                    }
                    //异常阈值
                    double errorValue = exception.getDouble("value");
                    //异常结果值
                    boolean isException;
                    switch (exception.getInt("type")) {
                        case 1:
                            isException = isEqual(value, errorValue);
                            break;
                        case 2:
                            isException = !isEqual(value, errorValue);
                            break;
                        case 3:
                            isException = (value > errorValue);
                            break;
                        case 4:
                            isException = (value < errorValue);
                            break;
                        default:
                            isException = false;
                            break;
                    }
                    if (isException) {
                        JSONObject param = new JSONObject();
                        param.put("f_error_level", exception.getString("level"));
                        param.put("f_error_type", exception.getString("name"));
                        String msg = exception.getString("msg");
                        if (exception.has("indexArray")) {
                            msg = format(msg, params, exception.getJSONArray("indexArray"));
                        }
                        // 如果有短信平台地址，代表可以发请求
                        if (exception.has("smsUrl")) {
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("f_userfiles_id", param.getString("f_userfiles_id"));
                            RestTools.post(exception.getString("smsUrl"), jsonObject);
                        }

                        param.put("f_error_msg", msg);
                        result.put(param);
                    }
                }
            }
        }
        return result;
    }

    private String format(String regex, JSONObject params, JSONArray paramsIndex) {
        for (int i = 0; i < paramsIndex.length(); i++) {
            String key = paramsIndex.getString(i);
            Object value = params.optString(key, "-");
            regex = regex.replaceAll("\\{" + i + "}", String.valueOf(value));
        }
        return regex;
    }

    private boolean isEqual(double a, double b) {
        return Double.doubleToLongBits(a) == Double.doubleToLongBits(b);
    }
}
