package com.aote.webmeter.enums.business;

import java.util.stream.Stream;

/**
 * 物联网表服务 档案开户状态
 * @author Mr.river
 */
public enum OpenAccountStateEnum {
    //未开户
    NO_ACCOUNT(0),
    //已开户
    OPEN_ACCOUNT(1),
    //待开户
    READY_ACCOUNT(2),
    //失败
    ERROR(3);

    private final Integer value;

    OpenAccountStateEnum(Integer value) {
        this.value = value;
    }

    public static OpenAccountStateEnum toType(Integer value) {
        return Stream.of(OpenAccountStateEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(Integer value){
        return toType(value) != null;
    }

    public Integer getValue(){
        return value;
    }
}
