package com.aote.webmeter.tools.iot;

import com.af.plugins.HttpDeleteWithBody;
import com.aote.webmeter.enums.IOTBusinessTypeEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.io.IOException;

/**
 * 电信IOT平台设备管理工具
 * @author Mr.river
 */
public class DeviceManagementTools {
	private static final Logger LOGGER = Logger.getLogger(DeviceManagementTools.class);

	/**
	 * 错误码：设备已被绑定
	 */
	private static final String DEVICE_BINDED_1 = "100416";
	private static final String DEVICE_BINDED_2 = "100426";
	/**
	 * 错误码：设备已被解绑
	 */
	private static final String DEVICE_CANCEL_BINDED_1 = "100403";
	private static final String DEVICE_CANCEL_BINDED_2 = "100418";

	/**
	 * 注册设备
	 * @param nodeId 模组号，即IMEI
	 * @return device_id
	 */
    public static String regDevice(String nodeId) throws IOException {
		JSONObject content = new JSONObject();
		content.put("nodeId", nodeId);
		content.put("verifyCode", nodeId);
		content.put("timeout", 0);

		JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.CREATE_DEVICE,new HttpPost(),content);

		if(result.has(IotCommonTools.ERROR_PARAMS_KEY)){
			if(DEVICE_BINDED_1.equals(result.get(IotCommonTools.ERROR_PARAMS_KEY)) || DEVICE_BINDED_2.equals(result.get(IotCommonTools.ERROR_PARAMS_KEY))){
				return "设备已被注册";
			}
			throw new RuntimeException(result.toString());
		} else {
			return (String) result.get("deviceId");
		}
	}

	public static String regDevice(String nodeId, String name) throws IOException {
		JSONObject content = new JSONObject();
		content.put("nodeId", nodeId);
		content.put("verifyCode", nodeId);
		content.put("timeout", 0);
		content.put("deviceName", name);

		JSONObject deviceInfo = new JSONObject();
		deviceInfo.put("manufacturerId", WebMeterInfo.getString("manuFacturerId"));
		deviceInfo.put("manufacturerName", WebMeterInfo.getString("manuFacturerName"));
		deviceInfo.put("deviceType", WebMeterInfo.getString("deviceType"));
		deviceInfo.put("model", WebMeterInfo.getString("meterModel"));
		deviceInfo.put("protocolType", "CoAP");

		content.put("deviceInfo",deviceInfo);

		JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.CREATE_DEVICE,new HttpPost(),content);

		if(result.has("status") && result.getInt("status") == HttpStatus.SC_BAD_REQUEST){
			return "设备已被注册";
		}
		if(result.has(IotCommonTools.ERROR_PARAMS_KEY)){
			if(DEVICE_BINDED_1.equals(result.get(IotCommonTools.ERROR_PARAMS_KEY)) || DEVICE_BINDED_2.equals(result.get(IotCommonTools.ERROR_PARAMS_KEY))){
				return "设备已被注册";
			}
			throw new RuntimeException(result.toString());
		} else {
			return (String) result.get("deviceId");
		}
	}

	/**
	 * 修改设备信息
	 * @param deviceId device_id，设备ID
	 * @param name 设备名
	 * @return 执行结果
	 */
	public static int modifyDeviceInfo(String deviceId, String name) throws IOException {
		JSONObject content = new JSONObject();
		content.put("name",name);
		content.put("manuFacturerId", WebMeterInfo.getString("manuFacturerId"));
		content.put("manuFacturerName", WebMeterInfo.getString("manuFacturerName"));
		content.put("deviceType", WebMeterInfo.getString("deviceType"));
		content.put("model", WebMeterInfo.getString("meterModel"));
		content.put("protocolType", "CoAP");

		JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.MODIFY_DEVICE,new HttpPut(),content,deviceId);

		if(result.has(IotCommonTools.ERROR_PARAMS_KEY)){
			throw new RuntimeException(result.toString());
		} else {
			return 0;
		}
	}

	/**
	 * 注销设备
	 * @param deviceId device_id，设备ID
	 * @return 执行结果
	 */
	public static int cancelDevice(String deviceId) throws IOException {
		JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.MODIFY_DEVICE,new HttpDeleteWithBody(),null,deviceId);

		if(result.has(IotCommonTools.ERROR_PARAMS_KEY)){
			if(DEVICE_CANCEL_BINDED_1.equals(result.get(IotCommonTools.ERROR_PARAMS_KEY)) || DEVICE_CANCEL_BINDED_2.equals(result.get(IotCommonTools.ERROR_PARAMS_KEY))){
				return 0;
			}
			throw new RuntimeException(result.toString());
		} else {
			return 0;
		}
	}
}
