package com.aote.webmeter.common.basic.builder;

import com.aote.webmeter.common.basic.param.SetInstructStateParam;
import com.aote.webmeter.enums.InstructStateEnum;
import lombok.Getter;

/**
 * 设置指令状态参数-构造器
 * @author Mr.river
 */
@Getter
public class SetInstructStateParamBuilder {

    private String id;
    private String commandId;
    private String condition;
    private InstructStateEnum state;
    private String metaData;
    private String receiveMsg;
    private String syncCommandId;

    public static SetInstructStateParamBuilder create(InstructStateEnum state, String id) {
        return new SetInstructStateParamBuilder(state, id,null, null);
    }

    public static SetInstructStateParamBuilder createByCommandId(InstructStateEnum state, String commandId) {
        return new SetInstructStateParamBuilder(state, null, commandId, null);
    }

    public static SetInstructStateParamBuilder createByCondition(InstructStateEnum state, String condition) {
        return new SetInstructStateParamBuilder(state, null, null, condition);
    }

    public SetInstructStateParam build() {
        return new SetInstructStateParam(this);
    }

    private SetInstructStateParamBuilder(InstructStateEnum state, String id, String commandId,String condition) {
        super();
        this.setState(state);
        this.setId(id);
        this.setCommandId(commandId);
        this.setCondition(condition);
    }

    public SetInstructStateParamBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public SetInstructStateParamBuilder setCommandId(String commandId) {
        this.commandId = commandId;
        return this;
    }

    public SetInstructStateParamBuilder setCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public SetInstructStateParamBuilder setState(InstructStateEnum state) {
        this.state = state;
        return this;
    }

    public SetInstructStateParamBuilder setMetaData(String metaData) {
        this.metaData = metaData;
        return this;
    }

    public SetInstructStateParamBuilder setReceiveMsg(String receiveMsg) {
        this.receiveMsg = receiveMsg;
        return this;
    }

    public SetInstructStateParamBuilder setSyncCommandId(String syncCommandId) {
        this.syncCommandId = syncCommandId;
        return this;
    }
}
