-- 公共SQL：生成充值指令（附带气价信息，适用SilverLight2）
-- 必选参数
-- f_meter_brand：表具品牌别名

SELECT
    -- 业务记录ID
    sell.id,
    -- 旧业务记录ID
    sell.id f_old_sell_id,
    -- 表档案ID
    u.id    userid,
    -- 表号
    u.f_meternumber,
    -- 充值金额
    sell.payvalue,
    -- 充值次数
    isnull(sell.f_times,u.f_times) f_times,
    -- 总购金额
    u.f_meteramountnums total,
    -- 结算类型（按金额，按气量）
    '按金额' f_collection_type,
    -- 阶梯周期（月）
    ISNULL(ui.f_stairmonths, 1) f_stairmonths,
    -- 阶梯气价
    ui.f_stair1price,
    ui.f_stair2price,
    ui.f_stair3price,
    -- 阶梯气量
    ui.f_stair1amount,
    ui.f_stair2amount,
    ui.f_stair3amount,
    -- 充值类型
    sell.type
FROM (
    SELECT f.id              id,
           f.f_userid        userid,
           f.f_meternumber   f_meternumber,
           f.f_grossproceeds payvalue,
           f.f_times         f_times,
            '补费扣费'         type
    FROM t_cbgas f
    WHERE f.f_payfeevalid = '有效'
      AND (f.f_sendsuccess IS NULL or f.f_sendsuccess = '未同步')
    UNION ALL
    SELECT s.id              id,
           s.f_userid        userid,
           s.f_meternumber   f_meternumber,
           s.f_grossproceeds payvalue,
           s.f_times         f_times,
           '充值'             type
    FROM t_sellinggas s
    WHERE s.f_payfeevalid = '有效'
      AND s.f_payfeetype = '机表收费'
      AND (s.f_sendsuccess IS NULL or s.f_sendsuccess = '未同步')
    UNION ALL
    SELECT h.id                   id,
           h.f_userid             userId,
           h.f_cmnewmeternumber   f_meternumber,
           h.f_prejine            payvalue,
           1                      f_times,
           '换表补气'               type
    FROM t_changmeter h
    WHERE h.f_prejine > 0
      AND (h.f_isSupplyGas IS NULL or h.f_isSupplyGas = '未同步')
    ) sell
    LEFT JOIN t_userfiles u ON u.f_userid = sell.userId AND u.f_meternumber = sell.f_meternumber
    LEFT JOIN t_userinfo ui ON u.f_userinfoid = ui.f_userid
WHERE u.f_aliasname = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND u.f_userstate = '正常'
ORDER BY sell.f_times
