/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.server.udp;

import com.af.plugins.ConvertTools;
import com.aote.logic.LogicServer;
import com.aote.webmeter.enums.MsgTypeEnum;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class UdpServer
extends Thread {
    private Selector selector;
    private int port;
    private LogicServer service;
    private String logicName;
    private MsgTypeEnum msgReceiveType;
    private MsgTypeEnum msgSendType;
    private static Logger log = Logger.getLogger(UdpServer.class);

    public UdpServer(String logicName, int port, LogicServer service, MsgTypeEnum msgReceiveType, MsgTypeEnum msgSendType) {
        this.logicName = logicName;
        this.port = port;
        this.service = service;
        this.msgReceiveType = msgReceiveType;
        this.msgSendType = msgSendType;
    }

    private void initServer() {
        try {
            DatagramChannel serverChannel = DatagramChannel.open();
            serverChannel.configureBlocking(false);
            serverChannel.socket().bind(new InetSocketAddress(this.port));
            this.selector = Selector.open();
            serverChannel.register(this.selector, 1);
            this.listen();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void listen() {
        System.out.println("\u670d\u52a1\u7aef\u3010" + this.port + "\u3011\u542f\u52a8\u6210\u529f\uff01");
        while (true) {
            try {
                block3: while (true) {
                    this.selector.select();
                    Iterator<SelectionKey> ite = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (!ite.hasNext()) continue block3;
                        SelectionKey key = ite.next();
                        ite.remove();
                        if (!key.isReadable()) continue;
                        this.read(key);
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)"UDP\u670d\u52a1\u5668\u53d1\u751f\u9519\u8bef\uff1a", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void read(SelectionKey key) throws IOException {
        String msg;
        SocketAddress client;
        DatagramChannel channel = (DatagramChannel)key.channel();
        channel.configureBlocking(false);
        ByteBuffer buffer = ByteBuffer.allocate(512);
        try {
            client = channel.receive(buffer);
        }
        catch (IOException e) {
            log.debug((Object)(channel.getRemoteAddress() + "\u65ad\u5f00\u8fde\u63a5..."));
            channel.close();
            log.debug((Object)"\u6e05\u9664\u7f13\u5b58...");
            buffer.clear();
            return;
        }
        byte[] data = buffer.array();
        switch (this.msgReceiveType) {
            default: {
                msg = ConvertTools.bytesToStr((byte[])data);
                break;
            }
            case HEX: {
                msg = ConvertTools.byteToHexStr((byte[])data);
            }
        }
        msg = msg.trim();
        log.debug((Object)("\u670d\u52a1\u7aef\u6536\u5230\u4fe1\u606f\uff1a" + msg));
        JSONObject params = new JSONObject();
        params.put("data", (Object)new JSONObject().put("value", (Object)msg));
        try {
            byte[] sendMsgBytes;
            String result = String.valueOf(this.service.run(this.logicName, params));
            log.debug((Object)("\u670d\u52a1\u7aef\u8fd4\u56de\u4fe1\u606f\uff1a" + result));
            switch (this.msgSendType) {
                default: {
                    sendMsgBytes = result.getBytes();
                    break;
                }
                case BASE64: {
                    sendMsgBytes = ConvertTools.base64Decode((byte[])result.getBytes());
                    break;
                }
                case HEX: {
                    sendMsgBytes = ConvertTools.hexStrToByte((String)result);
                    break;
                }
                case HEX_BASE64: {
                    sendMsgBytes = ConvertTools.base64Decode((byte[])ConvertTools.hexStrToByte((String)result));
                }
            }
            ByteBuffer outBuffer = ByteBuffer.wrap(sendMsgBytes);
            channel.send(outBuffer, client);
        }
        catch (Exception e) {
            log.error((Object)"\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.initServer();
    }
}

