package com.aote.webmeter.tools.tcp;

import com.af.plugins.ConvertTools;
import com.aote.logic.LogicServer;
import com.aote.webmeter.enums.MsgTypeEnum;
import org.apache.commons.codec.DecoderException;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * TCP通讯工具
 */
public class TcpTools {

    private static final Logger LOG = Logger.getLogger(TcpTools.class);

    private static final Map<String, ChannelData> CHANNEL_MAP = new ConcurrentHashMap<>();

    private static final ThreadLocal<String> CHANNEL_ADDRESS = new ThreadLocal<>();

    public static JSONObject getChannelData(String address,String getChannelDataName, JSONObject params, LogicServer service) {
        ChannelData data = CHANNEL_MAP.get(address);
        if(data != null) {
            JSONObject channelParams = null;
            params.put("address",address);
            String result = String.valueOf(service.run(getChannelDataName, params));
            if (result != null) {
                channelParams = new JSONObject(result);
                data.params = channelParams;
            }
            return channelParams;
        }else {
            return null;
        }
    }

    /**
     * 发送消息
     * @param message 消息体
     * @return 成功
     */
    public static String send(String message) throws DecoderException, IOException {
        return send(CHANNEL_ADDRESS.get(),message);
    }
    public static String send(String key, String message) throws IOException, DecoderException {
        ChannelData data = CHANNEL_MAP.get(key);
        if(data != null) {
            byte[] sendMsgBytes;
            ByteBuffer outBuffer;
            switch (data.msgTypeEnum) {
                case NORMAL:
                default:
                    sendMsgBytes = message.getBytes();
                    break;
                case BASE64:
                    sendMsgBytes = ConvertTools.base64Decode(message.getBytes());
                    break;
                case HEX:
                    sendMsgBytes = ConvertTools.hexStrToByte(message);
                    break;
                case HEX_BASE64:
                    sendMsgBytes = ConvertTools.base64Decode(ConvertTools.hexStrToByte(message));
                    break;
            }
            outBuffer = ByteBuffer.wrap(sendMsgBytes);
            data.channel.write(outBuffer);
            return "ok";
        } else {
            return "客户端不在线，请稍后尝试";
        }
    }

    public static void remove(String key) throws IOException {
        SocketChannel channel = CHANNEL_MAP.get(key).channel;
        if(channel != null){
            LOG.debug("TCP管道销毁：" + channel.getRemoteAddress());
            if(channel.isOpen()){
                channel.close();
            }
        }
        CHANNEL_MAP.remove(key);
        CHANNEL_ADDRESS.remove();
    }

    public static void setChannelMapValue(String key, ChannelData value) {
        CHANNEL_MAP.put(key, value);
    }

    public static void setChannelAddress(String key){
        CHANNEL_ADDRESS.set(key);
    }

    public static class ChannelData {
        MsgTypeEnum msgTypeEnum;
        SocketChannel channel;
        JSONObject params;

        public ChannelData(MsgTypeEnum m, SocketChannel c){
            this.msgTypeEnum = m;
            this.channel = c;
        }
    }
}
