package com.aote.webmeter.enums;

import java.util.stream.Stream;

/**
 * 物联网表服务 电信IOT平台接口地址
 * @author Mr.river
 */
public enum TelecomApiEnum {

    //BASE_URL
    BASE_URL("device.api.ct10649.com"),
    //BASE_PORT
    BASE_PORT("8743"),
    //AEP_URL
    AEP_URL("ag-api.ctwing.cn"),
    //AEP_PORT
    AEP_PORT("80"),
    //AUTH 鉴权接口
    AUTH_URL("https://" + BASE_URL.value + ":"+ BASE_PORT.value +"/iocm/app/sec/v1.1.0/login"),
    AEP_AUTH_URL("http://" + AEP_URL.value + ":"+ AEP_PORT.value +"/iocm/app/sec/v1.1.0/login"),
    //REFRESH_AUTH 刷新TOKEN接口
    REFRESH_AUTH_URL("https://" + BASE_URL.value + ":"+ BASE_PORT.value +"/iocm/app/sec/v1.1.0/refreshToken"),
    AEP_REFRESH_AUTH_URL("http://" + AEP_URL.value + ":"+ AEP_PORT.value +"/iocm/app/sec/v1.1.0/refreshToken"),
    //DEVICE_CREATE 设备创建接口
    DEVICE_CREATE_URL("https://" + BASE_URL.value + ":"+ BASE_PORT.value +"/iocm/app/reg/v1.1.0/deviceCredentials"),
    AEP_DEVICE_CREATE_URL("http://" + AEP_URL.value + ":"+ AEP_PORT.value +"/iocm/app/reg/v1.1.0/deviceCredentials"),
    //DEVICE_UPDATE 设备更新接口
    DEVICE_UPDATE_URL("https://" + BASE_URL.value + ":"+ BASE_PORT.value +"/iocm/app/dm/v1.4.0/devices"),
    AEP_DEVICE_UPDATE_URL("http://" + AEP_URL.value + ":"+ AEP_PORT.value +"/iocm/app/dm/v1.4.0/devices"),
    //SEND_INSTRUCT 发送指令接口
    SEND_INSTRUCT_URL("https://" + BASE_URL.value + ":"+ BASE_PORT.value +"/iocm/app/cmd/v1.4.0/deviceCommands"),
    AEP_SEND_INSTRUCT_URL("http://" + AEP_URL.value + ":"+ AEP_PORT.value +"/iocm/app/cmd/v1.4.0/deviceCommands"),
    //SUBSCRIPTIONS 推送订阅接口
    SUBSCRIPTIONS_URL("https://" + BASE_URL.value + ":" + BASE_PORT.value + "/iocm/app/sub/v1.2.0/subscriptions"),
    AEP_SUBSCRIPTIONS_URL("http://" + AEP_URL.value + ":" + AEP_PORT.value + "/iocm/app/sub/v1.2.0/subscriptions");

    private final String value;

    TelecomApiEnum(String value) {
        this.value = value;
    }

    public static TelecomApiEnum toType(String value) {
        return Stream.of(TelecomApiEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
