/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.server.tcp;

import com.af.plugins.JsonTools;
import com.aote.logic.LogicServer;
import com.aote.webmeter.enums.MsgTypeEnum;
import com.aote.webmeter.server.tcp.TcpServer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class TcpListener
implements ServletContextListener {
    private TcpServer[] tcpServers;
    private static final String PATH = "config/server/TCPListenerConfig.json";

    public void contextInitialized(ServletContextEvent sce) {
        if (TcpListener.class.getClassLoader().getResourceAsStream(PATH) != null) {
            JSONObject params = JsonTools.readJsonFile((String)PATH);
            String logicName = params.getString("callBackName");
            JSONArray ports = params.getJSONArray("tcpPort");
            boolean isHasChannelData = params.getBoolean("isHasChannelData");
            String getChannelDataName = params.has("getChannelDataName") ? params.getString("getChannelDataName") : null;
            this.tcpServers = new TcpServer[ports.length()];
            LogicServer service = (LogicServer)WebApplicationContextUtils.getWebApplicationContext((ServletContext)sce.getServletContext()).getBean(LogicServer.class);
            String msgReceiveType = params.getString("msgReceiveType");
            String msgSendType = params.getString("msgSendType");
            for (int i = 0; i < ports.length(); ++i) {
                TcpServer tcpServer;
                this.tcpServers[i] = tcpServer = new TcpServer(logicName, ports.getInt(i), service, MsgTypeEnum.toType(msgReceiveType), MsgTypeEnum.toType(msgSendType), isHasChannelData, getChannelDataName);
            }
        }
        for (TcpServer tcpServer : this.tcpServers) {
            tcpServer.start();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        for (TcpServer tcpServer : this.tcpServers) {
            if (tcpServer == null || !tcpServer.isInterrupted()) continue;
            tcpServer.interrupt();
        }
    }
}

