/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot;

import com.af.plugins.HttpConnectionPoolUtil;
import com.aote.redis.RedisUtil;
import com.aote.webmeter.enums.IOTBusinessTypeEnum;
import com.aote.webmeter.enums.WebmeterPropertiesIOTEnum;
import com.aote.webmeter.exception.NorthApiException;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.IotCommonTools;
import java.io.IOException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class AuthenticationTools {
    public static final String SELFCERTPWD = "IoM@1234";
    public static final String TRUSTCAPWD = "Huawei@123";
    private static final Logger LOGGER = Logger.getLogger(AuthenticationTools.class);
    private static volatile CloseableHttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CloseableHttpClient getHttpClient() {
        if (httpClient != null) return httpClient;
        Class<AuthenticationTools> clazz = AuthenticationTools.class;
        synchronized (AuthenticationTools.class) {
            if (httpClient != null) return httpClient;
            try {
                httpClient = HttpConnectionPoolUtil.getHttpClient((LayeredConnectionSocketFactory)AuthenticationTools.initSslConfig());
            }
            catch (NorthApiException e) {
                e.printStackTrace();
            }
            return httpClient;
        }
    }

    private static JSONObject getAuthInfo() {
        String secret;
        String appId;
        int isAep = IotCommonTools.getIsAep();
        if (isAep == 1) {
            appId = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.AEP_APIKEY);
            secret = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.AEP_SECRET);
        } else if (isAep == 0) {
            appId = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC_APIKEY);
            secret = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC_SECRET);
        } else {
            appId = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC2_APIKEY);
            secret = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC2_SECRET);
        }
        JSONObject result = new JSONObject();
        result.put("appId", (Object)appId);
        result.put("secret", (Object)secret);
        return result;
    }

    public static String getAuthToken(boolean force) {
        JSONObject authInfo = AuthenticationTools.getAuthInfo();
        String appId = authInfo.getString("appId");
        String secret = authInfo.getString("secret");
        String token = AuthenticationTools.getToken(appId, force);
        if (token != null) {
            return token;
        }
        return AuthenticationTools.getWebAuthToken(appId, secret, force);
    }

    public static String getAuthToken() {
        return AuthenticationTools.getAuthToken(false);
    }

    private static String requestGetToken(String appId, String secret) throws IOException {
        RedisUtil redisUtil = RedisUtil.getInstance();
        JSONObject content = new JSONObject();
        content.put("appId", (Object)appId);
        content.put("secret", (Object)secret);
        String refreshToken = AuthenticationTools.getRefreshToken(appId);
        if (refreshToken != null) {
            LOGGER.info((Object)(appId + ":\u8fdb\u884c\u5237\u65b0\u9274\u6743\u64cd\u4f5c"));
            content.put("refreshToken", (Object)refreshToken);
            JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.REFRESH_AUTH, (HttpEntityEnclosingRequestBase)new HttpPost(), content, null);
            if (result.has("errorEntity")) {
                redisUtil.delete(appId + "_refreshToken");
                return AuthenticationTools.requestGetToken(appId, secret);
            }
            String newAccessToken = result.getString("accessToken");
            String newRefreshToken = result.getString("refreshToken");
            redisUtil.set(appId + "_token", (Object)newAccessToken, Integer.valueOf(result.getInt("expiresIn") - 60));
            if (!refreshToken.equals(newRefreshToken)) {
                redisUtil.set(appId + "_refreshToken", (Object)newRefreshToken, Integer.valueOf(86340));
            }
            return newAccessToken;
        }
        LOGGER.info((Object)(appId + ":\u8fdb\u884c\u9274\u6743\u64cd\u4f5c"));
        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.AUTH, (HttpEntityEnclosingRequestBase)new HttpPost(), content, null);
        if (result.has("errorEntity")) {
            throw new RuntimeException(result.toString());
        }
        String newRefreshToken = result.getString("refreshToken");
        redisUtil.set(appId + "_refreshToken", (Object)newRefreshToken, Integer.valueOf(86340));
        return AuthenticationTools.requestGetToken(appId, secret);
    }

    private static String getToken(String appId, boolean force) {
        if (force) {
            return null;
        }
        RedisUtil redisUtil = RedisUtil.getInstance();
        Object token = redisUtil.get(appId + "_token");
        if (token != null) {
            LOGGER.info((Object)(appId + ":\u83b7\u53d6\u73b0\u6709token"));
            return String.valueOf(token);
        }
        return null;
    }

    public static synchronized String getWebAuthToken(String appId, String secret, boolean force) {
        RedisUtil redisUtil = RedisUtil.getInstance();
        String[] newAccessToken = new String[1];
        redisUtil.lock(appId, () -> {
            String token = AuthenticationTools.getToken(appId, force);
            if (force) {
                LOGGER.info((Object)(appId + ":\u8fdb\u884c\u5f3a\u5236\u5237\u65b0\u9274\u6743\u64cd\u4f5c"));
            }
            if (token == null) {
                try {
                    newAccessToken[0] = AuthenticationTools.requestGetToken(appId, secret);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                newAccessToken[0] = token;
            }
        });
        return newAccessToken[0];
    }

    private static String getRefreshToken(String appId) {
        RedisUtil redisUtil = RedisUtil.getInstance();
        Object token = redisUtil.get(appId + "_refreshToken");
        if (token != null) {
            return String.valueOf(token);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    protected static SSLConnectionSocketFactory initSslConfig() throws NorthApiException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

