package com.aote.webmeter.tools;

import com.aote.webmeter.common.utils.Condition;

/**
 * 物联网表-营收业务兼容性组件(适用Java)
 * @author 物联网表小组
 */
public class StandardCompatTools extends CompatTools{
    public static Condition getBasicCondition(String userId){
        Condition result = Condition.build();
        switch (WebMeterInfo.getSaleNameEnum()){
            case Vue_V1:
            case Vue_V2:
                return result.eq("t_userfiles.f_user_id",userId);
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return result.eq("t_userfiles.id",userId);
            case Vue_V3:
            default:
                return result.eq("t_userfiles.f_userfiles_id",userId);
        }
    }
}
