package com.aote.webmeter.common.template.saveInstruct;

import com.aote.webmeter.common.basic.manage.InstructManage;
import com.aote.webmeter.common.dao.ChangeMeterDataDao;
import com.aote.webmeter.common.dao.SaleDataDao;
import com.aote.webmeter.common.dao.UserFilesDao;
import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.tools.SpringBeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 保存余额同步指令模板
 * @author Mr.river
 */
@Template
public class SaveChargeMeterInstructTemplate extends BasicSaveInstructTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveChargeMeterInstructTemplate.class);

    protected SaveChargeMeterInstructTemplate(InstructManage instructManage, UserFilesDao userFilesDao, SaleDataDao saleDataDao, ChangeMeterDataDao changeMeterDataDao) {
        super(instructManage, userFilesDao, saleDataDao, changeMeterDataDao);
    }

    public static class Builder extends BasicSaveInstructTemplate.Builder {
        private final SaveChargeMeterInstructTemplate template;

        public Builder(String userId) {
            super(InstructTypeEnum.ChargeMeter, userId);
            template = SpringBeanUtil.getBean(SaveChargeMeterInstructTemplate.class);
        }

        @Override
        public SaveChargeMeterInstructTemplate build() {
            return template;
        }
    }
}
