package com.aote.webmeter.common.template.pour.param;


import com.aote.webmeter.common.basic.manage.param.AbstractParam;
import com.aote.webmeter.common.basic.manage.param.AbstractParamBuilder;
import com.aote.webmeter.common.dto.GetInstructDto;
import com.aote.webmeter.enums.business.InstructStateEnum;
import lombok.Getter;
import org.json.JSONObject;

/**
 * 调用执行指令模板时注入业务的回调参数器
 *
 * @author Mr.river
 */
@Getter
public class RunTemplatePourCallParam extends AbstractParam {
    /**
     * 表档案ID
     */
    private String userId;
    /**
     * 表号
     */
    private String meterNumber;
    /**
     * 指令状态
     */
    private InstructStateEnum state;
    /**
     * 需要执行的指令数据（默认通过Timer查询SQL后传入）
     */
    private GetInstructDto getInstructDto;
    /**
     * 查询指定条件的表具待发送指令-Result
     */
    private GetInstructDto instructDto;
    /**
     * 额外参数
     */
    private JSONObject extraParams;

    private RunTemplatePourCallParam(){

    }

    public static class Builder extends AbstractParamBuilder {
        private final RunTemplatePourCallParam result;

        public Builder(String userId, String meterNumber, InstructStateEnum state, GetInstructDto getInstructDto) {
            result = new RunTemplatePourCallParam();
            result.userId = userId;
            result.meterNumber = meterNumber;
            result.state = state;
            result.getInstructDto = getInstructDto;
        }

        public Builder extraParams(JSONObject extraParams){
            result.extraParams = extraParams;
            return this;
        }

        @Override
        public RunTemplatePourCallParam build() {
            return result;
        }
    }
}
