package com.aote.webmeter.common.template;

import com.aote.webmeter.common.template.result.TemplateResult;

/**
 * 抽象模板
 *
 * @author Mr.river
 */
public abstract class AbstractTemplate {

    /**
     * 模板执行前操作
     */
    protected abstract void beforeExec();

    /**
     * 模板执行
     * @return 模板执行结果
     */
    public abstract TemplateResult exec();

    /**
     * 模板执行后操作
     */
    protected abstract void afterExec();

}
