package com.aote.webmeter.common.entity;

import com.aote.util.JsonHelper;
import com.aote.webmeter.enums.business.MeterTableStateEnum;
import lombok.Data;
import org.json.JSONObject;

/**
 * 档案实体
 *
 * @author Mr.river
 */
@Data
public class UserFilesEntity {
    /**
     * 表档案ID
     */
    private String userId;
    /**
     * 表号
     */
    private String f_meternumber;
    /**
     * 表档案状态
     */
    private MeterTableStateEnum f_table_state;

    private UserFilesEntity(){

    }

    public static class Builder {
        private final UserFilesEntity entity;

        public Builder(JSONObject userFiles) {
            entity = JsonHelper.toParse(userFiles, UserFilesEntity.class);
        }

        public UserFilesEntity build() {
            return entity;
        }
    }
}
