package com.aote.webmeter.common.basic.manage.param.instructmanage;

import com.aote.webmeter.common.basic.manage.param.AbstractParam;
import com.aote.webmeter.common.basic.manage.param.AbstractParamBuilder;
import com.aote.webmeter.common.utils.NecessaryValue;
import com.aote.webmeter.common.utils.Condition;
import com.aote.webmeter.tools.StandardCompatTools;
import lombok.Getter;
import org.json.JSONObject;

import java.util.Optional;

/**
 * 执行指令参数器
 * @author Mr.river
 */
@Getter
public class RunInstructParam extends AbstractParam {

    /**
     * 表档案ID
     */
    private NecessaryValue<String, Condition> userId;
    /**
     * 条件表达式
     */
    private NecessaryValue<Condition, Condition> condition;
    /**
     * 指令自动托管：指令执行结果不是失败时，自动下发后续指令，默认为false，
     * 注意：这是一种利用业务特性递归实现指令循环发送的写法，你需要确保业务中支持指令回调，并且主动调用了执行指令的方法。
     * 使用continue会丢失具体执行指令方法的返回值
     */
    private Boolean trusteeship;
    /**
     * 需要在执行指令时额外传入的参数
     */
    private JSONObject extraParams;

    private RunInstructParam(){

    }

    public static class Builder extends AbstractParamBuilder {
        private final RunInstructParam param;

        public Builder() {
            param = new RunInstructParam();
        }

        @Override
        public RunInstructParam build() {
            param.condition = checkAndGetNecessaryParams(this.param);
            param.trusteeship = Optional.ofNullable(param.trusteeship).orElse(false);
            param.extraParams = Optional.ofNullable(param.extraParams).orElseGet(JSONObject::new);
            return param;
        }

        public Builder userId(String userId){
            param.userId = new NecessaryValue<>(1, userId, () -> StandardCompatTools.getBasicCondition(userId));
            return this;
        }

        public Builder condition(Condition condition){
            param.condition = new NecessaryValue<>(2, condition);
            return this;
        }

        public Builder trusteeship(boolean trusteeship){
            param.trusteeship = trusteeship;
            return this;
        }

        public Builder extraParams(JSONObject extraParams){
            param.extraParams = extraParams;
            return this;
        }
    }

    public void setTrusteeship(Boolean trusteeship){
        this.trusteeship = trusteeship;
    }

    public Condition getCondition(){
        return this.condition.getOutValue();
    }

    public String getUserId(){
        return this.userId.getInValue();
    }
}
