package com.aote.webmeter.common.entity;

import com.aote.util.JsonHelper;
import lombok.Data;
import org.json.JSONObject;

/**
 * 结算户档案实体
 *
 * @author Mr.river
 */
@Data
public class SettlementUserInfoEntity {
    private Integer version;
    private Double f_balance;
    private String f_user_type;
    private String f_gasproperties;
    private String f_user_name;
    private String f_userinfo_code;
    private Integer f_people_num;
    private Integer f_price_id;
    private String f_address;

    private SettlementUserInfoEntity(){

    }

    public Integer getF_price_id(){
        return f_price_id == null ? 0 : f_price_id;
    }

    public String getF_address(){
        return f_address == null ? "地址信息不存在" : f_address;
    }

    public Double getF_balance(){
        return f_balance == null ? 0 : f_balance;
    }

    public static class Builder {
        private final SettlementUserInfoEntity entity;

        public Builder(JSONObject userInfo) {
            entity = JsonHelper.toParse(userInfo, SettlementUserInfoEntity.class);
        }

        public SettlementUserInfoEntity build() {
            return entity;
        }
    }
}
