package com.aote.webmeter.common.entity;

import com.aote.util.JsonHelper;
import com.aote.webmeter.enums.SaleVersionEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import lombok.Data;
import org.json.JSONObject;

/**
 * 结算表档案实体
 *
 * @author Mr.river
 */
@Data
public class SettlementUserFilesEntity {
    /**
     * 表档案ID
     */
    private Integer f_userfiles_id;
    /**
     * 表档案编号
     */
    private Integer f_user_id;
    /**
     * 表号
     */
    private String f_meternumber;
    /**
     * 用户编号
     */
    private String f_userinfo_id;
    /**
     * 气表品牌ID
     */
    private Integer f_gasbrand_id;
    /**
     * 抄表次数
     */
    private Integer f_meteread_number;
    /**
     * 气价ID
     */
    private Integer f_price_id;
    /**
     * 用户类型
     */
    private String f_user_type;
    /**
     * 用气属性
     */
    private String f_gas_properties;
    /**
     * 用户地址ID
     */
    private Integer f_useraddress_id;
    /**
     * 表底数
     */
    private Double f_meter_base;
    /**
     * 表档案余额
     */
    private Double f_balance_amount;
    /**
     * 表档案余量
     */
    private Double f_balance_gas;
    /**
     * 最近抄表日期
     */
    private String f_meteread_date;
    /**
     * 累计用气金额
     */
    private Double f_total_usegas_amount;
    /**
     * 进气量
     */
    private Double f_input_gas;
    /**
     * 总购金额
     */
    private Double f_total_fee;
    /**
     * 开户时间
     */
    private String f_open_date;
    /**
     * 版本号
     */
    private Integer version;
    /**
     * 分公司信息
     */
    private String f_filiale;
    private String f_filialeid;
    private String f_filialeids;
    private String f_outlets;
    private String f_orgstr;
    private String f_orgid;
    private String f_depid;
    private String f_orgname;
    private String f_depname;

    private SettlementUserFilesEntity(){

    }

    public Integer getF_meteread_number(){
        return f_meteread_number == null ? 0 : f_meteread_number;
    }

    public Integer getF_price_id(){
        return f_price_id == null ? 0 : f_price_id;
    }

    public Integer getF_useraddress_id(){
        return f_useraddress_id == null ? 0 : f_useraddress_id;
    }

    public Double getF_balance_amount(){
        return f_balance_amount == null ? 0 : f_balance_amount;
    }

    public Double getF_meter_base(){
        return f_meter_base == null ? 0 : f_meter_base;
    }

    public Double getF_total_usegas_amount(){
        return f_total_usegas_amount == null ? 0 : f_total_usegas_amount;
    }

    public Integer getUserFilesUserId(){
        SaleVersionEnum saleVersionEnum = WebMeterInfo.getSaleNameEnum();
        if(saleVersionEnum == SaleVersionEnum.Vue_V3){
            return f_userfiles_id;
        } else {
            return f_user_id;
        }
    }

    public static class Builder {
        private final SettlementUserFilesEntity entity;

        public Builder(JSONObject userFiles) {
            entity = JsonHelper.toParse(userFiles, SettlementUserFilesEntity.class);
        }

        public SettlementUserFilesEntity build() {
            return entity;
        }
    }
}
