package com.aote.webmeter.common.entity;

import com.aote.util.JsonHelper;
import lombok.Data;
import org.json.JSONObject;

/**
 * 气表品牌实体
 *
 * @author Mr.river
 */
@Data
public class GasBrandEntity {
    private String f_meter_brand;
    private String f_meter_type;

    private GasBrandEntity(){

    }

    public static class Builder {
        private final GasBrandEntity entity;

        public Builder(JSONObject gasBrand) {
            entity = JsonHelper.toParse(gasBrand, GasBrandEntity.class);
        }

        public GasBrandEntity build() {
            return entity;
        }
    }
}
