package com.aote.webmeter.tools;

import com.af.plugins.ConvertTools;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;

/**
 * 日期兼容插件
 * @author Mr.river
 */
public class DateTools {
	/**
	 * 计算阶梯开始时间和结束时间
	 * @param stairMonths 阶梯月数
 	 */
	public static JSONObject computeDate(Object stairMonths) {
		String startDate;
		String endDate = com.af.plugins.DateTools.getNow("yyyy-MM-dd");

		Calendar cal = Calendar.getInstance();
		int year = Integer.parseInt(endDate.substring(0, 4));
		int month = Integer.parseInt(endDate.substring(5, 7));
		int day = Integer.parseInt(endDate.substring(8, 10));
		cal.set(year, month - 1, day);

		// 计算当前月在哪个阶梯区间
		int thismonth = cal.get(Calendar.MONTH);
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		int stairmonthsValue = Integer.parseInt(stairMonths.toString());
		if (stairmonthsValue == 1) {
			cal.set(Calendar.DAY_OF_MONTH, 1);
			startDate = format.format(cal.getTime());
			cal.set(Calendar.DAY_OF_MONTH,
					cal.getActualMaximum(Calendar.DAY_OF_MONTH));
			endDate = format.format(cal.getTime());
		} else if (stairmonthsValue == 0) {
			startDate = "";
			endDate = "";
		} else {
			/*
			 * 阶梯起始月数计算起始月 = 当前月/阶梯月数*阶梯月数+1结束月 = 当前月/阶梯月数*阶梯月数+阶梯月数注：该运算
			 * 当前月是12月时则需要剪1 上面已经算出阶梯月数为1个月时的金额一下运算阶梯月数至少为两个月 所以对算区间没有影响
			 */
			if (thismonth == 12) {
				thismonth = 11;
			}
			// 计算起始月
			int star = Math.round(thismonth / stairmonthsValue) * stairmonthsValue + 1;
			// 计算结束月
			int end = Math.round(thismonth / stairmonthsValue) * stairmonthsValue
					+ stairmonthsValue;
			// 获得起始日期和结束日期
			cal.set(Calendar.MONTH, star - 1);
			cal.set(Calendar.DAY_OF_MONTH, 1);
			startDate = format.format(cal.getTime());
			cal.set(Calendar.MONTH, end - 1);
			cal.set(Calendar.DAY_OF_MONTH,
					cal.getActualMaximum(Calendar.DAY_OF_MONTH));
			endDate = format.format(cal.getTime());
		}
		JSONObject jo = new JSONObject();
		jo.put("startDate", startDate);
		jo.put("endDate", endDate);

		return jo;
	}

	public static void main(String[] args) {
		BigDecimal bigDecimal = new BigDecimal("9.306289422644061E+173");
		System.out.println(ConvertTools.formatNumber(bigDecimal));
	}
}
