package com.aote.webmeter.enums.business;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

/**
 * 物联网表服务 结算类型
 * @author Mr.river
 */
public enum SettlementTypeEnum {
    //按金额
    BY_AMOUNT("按金额"),
    //按气量
    BY_VOLUME("按气量");

    private String value;

    SettlementTypeEnum(String value) {
        this.value = value;
    }

    @JsonCreator
    public static SettlementTypeEnum toType(String value) {
        return Stream.of(SettlementTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(SettlementTypeEnum.BY_AMOUNT);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    @JsonValue
    public String getValue(){
        return value;
    }

    private SettlementTypeEnum setValue(String value){
        this.value = value;
        return this;
    }
}
