package com.aote.webmeter.common.dao;

import com.aote.sql.SqlServer;
import com.aote.webmeter.tools.CompatTools;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 换表数据-数据库操作
 *
 * @author Mr.river
 */
@Transactional(rollbackFor=Exception.class)
@Component
public class ChangeMeterDataDao extends AbstractDao {
    private final SqlServer sqlServer;

    public ChangeMeterDataDao(SqlServer sqlServer) {
        this.sqlServer = sqlServer;
    }

    /**
     * 更新换表记录的同步状态
     * @param id 充值记录ID
     */
    public void updateChangeMeterSyncState(String id){
        sqlServer.run(CompatTools.getUpdateChangeMeterSql(id));
    }
}
