package com.aote.webmeter.common.basic.manage;

import com.af.plugins.JsonTools;
import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;
import com.aote.webmeter.common.basic.manage.param.instructmanage.GetWaitInstructParam;
import com.aote.webmeter.common.basic.manage.param.instructmanage.RunInstructParam;
import com.aote.webmeter.common.basic.manage.param.instructmanage.SaveInstructParam;
import com.aote.webmeter.common.basic.manage.param.instructmanage.SetInstructStateParam;
import com.aote.webmeter.common.basic.manage.result.GetWaitInstructResult;
import com.aote.webmeter.common.dao.InstructDao;
import com.aote.webmeter.common.dao.UserFilesDao;
import com.aote.webmeter.common.dto.GetInstructDto;
import com.aote.webmeter.common.entity.InstructEntity;
import com.aote.webmeter.common.template.pour.RunTemplatePour;
import com.aote.webmeter.common.template.result.RunInstructTemplateResult;
import com.aote.webmeter.common.template.runInstruct.BasicRunInstructTemplate;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.tools.CompatTools;
import com.aote.webmeter.tools.GetInstructsTools;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 指令管理
 */
@Transactional(rollbackFor=Exception.class)
@Component
public class InstructManage {

    private static final Logger LOGGER = LoggerFactory.getLogger(InstructManage.class);

    private final EntityServer entityServer;

    private final InstructDao instructDao;

    private final UserFilesDao userFilesDao;

    public InstructManage(EntityServer entityServer, InstructDao instructDao, UserFilesDao userFilesDao, LogicServer logicServer) {
        this.entityServer = entityServer;
        this.instructDao = instructDao;
        this.userFilesDao = userFilesDao;
    }

    /**
     * 生成物联网表指令
     * @param param 保存指令参数器
     * @return 生成的指令ID
     */
    public String save(SaveInstructParam param) {
        //查询用户档案，获取生成指令所需的信息
        JSONArray userFilesInfo = userFilesDao.getMeterInfoByCreateInstruct(param.getUserId(), param.getF_alias(),null);
        //对冗余指令进行处理
        if(param.getF_inputtor() != InstructInputtorEnum.SYSTEM_DEFAULT &&
                param.getF_inputtor() != InstructInputtorEnum.CHARGE){
            if(param.getF_instruct_type() == InstructTypeEnum.ValveControl){
                instructDao.updateRedundancyValveControlInstruct(param.getUserId());
            } else {
                instructDao.updateRedundancyOtherInstruct(param.getUserId(), param.getF_instruct_type(), param.getF_instruct_title());
            }
        }
        //获取表具信息
        JSONObject userFiles = userFilesInfo.getJSONObject(0);
        //组织指令实体
        InstructEntity instructData = new InstructEntity.Builder(param, userFiles).build();
        //获取指令表名称
        String tableName = CompatTools.getInstructTableName();
        //组织保存指令
        JSONObject instruct = JsonTools.convertToJson(entityServer.partialSaveByEntity(tableName, instructData));
        LOGGER.info("--------{}指令保存成功--------",param.getF_instruct_type().getValue());
        return String.valueOf(instruct.get("id"));
    }

    /**
     * 设置指令执行状态
     * @param param 设置指令状态参数器
     * @return 影响的指令行数
     */
    public int setInstructState(SetInstructStateParam param){
        return instructDao.updateInstructState(param);
    }

    /**
     * 执行指令模板
     * @param param 执行指令参数器
     * @return 执行指令模板的返回
     */
    public RunInstructTemplateResult runTemplateInstruct(RunInstructParam param){
        //执行结果
        RunInstructTemplateResult result = null;
        //获取待执行的指令
        GetWaitInstructResult waitInstruct = getWaitInstructResult(new GetWaitInstructParam.Builder().build(param));
        //如果存在待执行的指令
        if(waitInstruct.getTotal() > 0){
            GetInstructDto dto = waitInstruct.getInstructs().get(0);
            InstructTypeEnum typeEnum = dto.getF_instruct_type();
            LOGGER.info("待执行指令类型：" + typeEnum.getValue());
            //注入一些通用参数
            final JSONObject extraParams = new JSONObject();
            extraParams.put("instructCount",waitInstruct.getTotal());
            extraParams.put("deviceId",dto.getF_device_id());
            JsonTools.addJSON(extraParams,param.getExtraParams());
            //执行指令
            RunTemplatePour pour = GetInstructsTools.getInstructPour(typeEnum.getValue());
            //获取并调用执行指令模板
            BasicRunInstructTemplate.Builder templateBuilder = GetInstructsTools.getInstructTemplateObject(typeEnum, dto, pour);
            BasicRunInstructTemplate template = templateBuilder.templatePourExtraParams(extraParams).build();
            result = template.exec();
            //如果需要执行后续指令并且本次指令执行结果不是失败
            if(param.getTrusteeship() && result.getState() != InstructStateEnum.FAILED){
                LOGGER.info("继续执行后续指令");
                //如果指令的返回值中，重定义了是否下发后续指令，则覆盖原值
                param.setTrusteeship(result.getTrusteeship());
                //递归调用
                runTemplateInstruct(param);
            }
        } else {
            LOGGER.info("所有待发送指令执行完毕！");
        }
        return result;
    }

    /**
     * 获取待执行的指令集
     * @param param 获取待执行指令参数器
     * @return 获取待执行指令返回结果
     */
    public GetWaitInstructResult getWaitInstructResult(GetWaitInstructParam param){
        return instructDao.getWaitInstructs(param.getCondition());
    }

    /**
     * 更新临时指令和持久指令的状态
     * @param userId 表档案ID
     */
    public void updateInstructStatus(String userId){
        instructDao.updateNoResponseAndTimeOutLastingInstruct(userId);
        instructDao.updateNoResponseTemporaryInstruct(userId);
        instructDao.updateReadyTemporaryInstruct(userId);
    }
}
