/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.timer;

import com.af.plugins.CommonTools;
import com.af.plugins.JsonTools;
import com.af.plugins.RestTools;
import com.aote.module.ModuleMapper;
import com.aote.rs.LogicService;
import com.aote.rs.SqlService;
import com.aote.sql.SqlMapper;
import com.aote.webmeter.enums.RestCodeEnum;
import com.aote.webmeter.enums.SaleVersionEnum;
import com.aote.webmeter.enums.WebmeterPropertiesEnum;
import com.aote.webmeter.exception.WebmeterException;
import com.aote.webmeter.tools.CompatTools;
import com.aote.webmeter.tools.WebMeterInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebMeterTimer {
    private static final Logger LOGGER = Logger.getLogger(WebMeterTimer.class);
    private static final Map<String, JSONArray> SAVE_BUSINESS_LIST = new HashMap<String, JSONArray>(3);
    private static final String SAVE_BUSINESS_LIST_PATH = "saveBusiness.json";
    private static final Map<String, JSONArray> SEND_BUSINESS_LIST = new HashMap<String, JSONArray>(3);
    private static final String SEND_BUSINESS_LIST_PATH = "sendBusiness.json";
    private static final Map<String, JSONArray> SEND_BUSINESS_LIST_2 = new HashMap<String, JSONArray>(3);
    private static final String SEND_BUSINESS_LIST_PATH_2 = "sendBusiness2.json";
    private static final Map<String, JSONArray> SEND_BUSINESS_LIST_3 = new HashMap<String, JSONArray>(3);
    private static final String SEND_BUSINESS_LIST_PATH_3 = "sendBusiness3.json";
    @Autowired
    private SqlService sqlService;
    @Autowired
    private LogicService logicService;

    public WebMeterTimer() {
        WebMeterTimer.load();
    }

    public static void load() {
        Map map = ModuleMapper.getMap();
        for (String moduleName : map.keySet()) {
            JSONArray business;
            Object modulePath = (String)((Map)map.get(moduleName)).get("path");
            modulePath = modulePath == null ? "" : (String)modulePath + "/";
            String saveBusinessListPath = (String)modulePath + moduleName + "/saveBusiness.json";
            String sendBusinessListPath = (String)modulePath + moduleName + "/sendBusiness.json";
            String sendBusinessListPath2 = (String)modulePath + moduleName + "/sendBusiness2.json";
            String sendBusinessListPath3 = (String)modulePath + moduleName + "/sendBusiness3.json";
            if (WebMeterTimer.class.getClassLoader().getResourceAsStream(saveBusinessListPath) != null) {
                business = JsonTools.readJsonArrayFile((String)saveBusinessListPath);
                SAVE_BUSINESS_LIST.put(moduleName, business);
            }
            if (WebMeterTimer.class.getClassLoader().getResourceAsStream(sendBusinessListPath) != null) {
                business = JsonTools.readJsonArrayFile((String)sendBusinessListPath);
                SEND_BUSINESS_LIST.put(moduleName, business);
            }
            if (WebMeterTimer.class.getClassLoader().getResourceAsStream(sendBusinessListPath2) != null) {
                JSONArray business2 = JsonTools.readJsonArrayFile((String)sendBusinessListPath2);
                SEND_BUSINESS_LIST_2.put(moduleName, business2);
            }
            if (WebMeterTimer.class.getClassLoader().getResourceAsStream(sendBusinessListPath3) == null) continue;
            JSONArray business3 = JsonTools.readJsonArrayFile((String)sendBusinessListPath3);
            SEND_BUSINESS_LIST_3.put(moduleName, business3);
        }
    }

    public static void clear() {
        SAVE_BUSINESS_LIST.clear();
        SEND_BUSINESS_LIST.clear();
        SEND_BUSINESS_LIST_2.clear();
        SEND_BUSINESS_LIST_3.clear();
    }

    public void doBusiness(String moduleName, String alias, String type, JSONObject business) {
        String businessName = business.getString("name");
        String logicName = business.getString("logicName");
        JSONObject data = business.getJSONObject("data");
        data.put("moduleName", (Object)moduleName);
        LOGGER.info((Object)("======\u6a21\u5757\uff1a\u3010" + moduleName + "\u3011\u5f00\u59cb" + type + "\u3010" + businessName + "\u3011\u6307\u4ee4\u4e1a\u52a1\u6d41\u7a0b======"));
        boolean isRunSql = business.has("sqlData");
        if (isRunSql) {
            JSONObject sqlData = business.getJSONObject("sqlData");
            JSONArray resultArray = this.getSqlResult(sqlData, alias);
            if (resultArray != null) {
                resultArray.forEach(item -> {
                    data.put("object", item);
                    this.runLogic(logicName, data);
                });
            }
        } else {
            this.runLogic(logicName, data);
        }
        LOGGER.info((Object)("======\u6a21\u5757\uff1a\u3010" + moduleName + "\u3011" + type + "\u3010" + businessName + "\u3011\u6307\u4ee4\u4e1a\u52a1\u6d41\u7a0b\u7ed3\u675f======"));
    }

    public JSONArray getSqlResult(JSONObject sqlData, String alias) {
        boolean isAutoVersion;
        SaleVersionEnum saleVersionEnum;
        if (sqlData.has("isWeb")) {
            String sqlUrl = WebMeterInfo.getString(sqlData.getString("sqlUrl"));
            JSONObject sqlParams = sqlData.getJSONObject("sqlParams");
            String restType = sqlData.getString("restType");
            String result = "";
            try {
                result = restType.equals(RestCodeEnum.GET.getValue()) ? RestTools.get((String)sqlUrl, (JSONObject)sqlParams) : RestTools.post((String)sqlUrl, (JSONObject)sqlParams);
                return JsonTools.parseArray((String)result);
            }
            catch (JSONException e) {
                LOGGER.error((Object)("\u8bf7\u6c42\u4e1a\u52a1\u6240\u9700SQL\u7684\u7f51\u7edc\u8d44\u6e90\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u9884\u671f\u503c\u3002\u8fd4\u56de\u503c\uff1a" + result));
                return null;
            }
            catch (Exception e) {
                LOGGER.error((Object)"\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                return null;
            }
        }
        try {
            saleVersionEnum = WebMeterInfo.getSaleNameEnum();
        }
        catch (WebmeterException e) {
            saleVersionEnum = null;
        }
        boolean bl = isAutoVersion = sqlData.has("isAutoVersion") && sqlData.getBoolean("isAutoVersion");
        if (!isAutoVersion && saleVersionEnum != null) {
            Set regExSet = sqlData.keySet();
            for (String versionRegEx : regExSet) {
                Pattern pattern = Pattern.compile("^" + versionRegEx + "$", 2);
                Matcher matcher = pattern.matcher(saleVersionEnum.getValue());
                if (!matcher.find()) continue;
                sqlData = sqlData.getJSONObject(versionRegEx);
                break;
            }
        }
        if (sqlData.has("sqlName")) {
            boolean isAutoDataSource;
            String sqlName = sqlData.getString("sqlName");
            if (isAutoVersion) {
                sqlName = sqlData.has("baseType") ? CompatTools.getResName(sqlName, sqlData.getInt("baseType")) : CompatTools.getResName(sqlName);
            }
            boolean bl2 = isAutoDataSource = sqlData.has("isAutoDataSource") && sqlData.getBoolean("isAutoDataSource");
            if (isAutoDataSource) {
                sqlName = CompatTools.getDataSourceResName(sqlName);
            }
            if (SqlMapper.getSql((String)sqlName) == null) {
                LOGGER.info((Object)("\u672a\u627e\u5230" + WebMeterInfo.getSaleName() + "\u4e2d\u540d\u4e3a\u3010" + sqlName + "\u3011\u7684SQL\u6620\u5c04\u6587\u4ef6"));
                return null;
            }
            JSONObject sqlParams = sqlData.getJSONObject("sqlParams");
            if (!sqlParams.isEmpty()) {
                for (String paramKey : sqlParams.keySet()) {
                    String value = CommonTools.parametricStr((String)sqlParams.getString(paramKey), WebMeterInfo.getMap());
                    sqlParams.put(paramKey, (Object)value);
                }
            }
            if (saleVersionEnum != null) {
                switch (saleVersionEnum) {
                    case Vue_V1: 
                    case Vue_V2: 
                    case Vue_V3: 
                    case V4: {
                        JSONArray gasBrandArray;
                        try {
                            gasBrandArray = new JSONArray(this.sqlService.txQuery("SELECT id FROM t_gasbrand WHERE f_alias = '" + alias + "'"));
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)"\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                            return null;
                        }
                        String gasBrandIds = gasBrandArray.length() > 0 ? CommonTools.union((JSONArray)gasBrandArray, (String)"id") : "'-1'";
                        sqlParams.put("gasBrandIds", (Object)gasBrandIds);
                        break;
                    }
                }
            }
            sqlParams.put("f_meter_brand", (Object)alias);
            sqlParams.put("userIdColumn", (Object)CompatTools.getUserFilesId());
            int pageSize = 2000;
            boolean isHasPageSize = sqlData.has("pageSize");
            if (isHasPageSize && (pageSize = sqlData.getInt("pageSize")) == 0) {
                pageSize = 9999999;
            }
            try {
                JSONObject params = new JSONObject();
                params.put("data", (Object)sqlParams);
                return new JSONArray(this.sqlService.txExecute(sqlName, 1, pageSize, params.toString()));
            }
            catch (Exception e) {
                LOGGER.error((Object)"\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private void runLogic(String logicName, JSONObject data) {
        try {
            this.logicService.xtSave(logicName, data.toString());
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u3010" + logicName + "\u3011\u51fa\u73b0\u5f02\u5e38\uff1a"), (Throwable)e);
        }
    }

    public void doSaveBusiness() {
        for (Map.Entry<String, JSONArray> entry : SAVE_BUSINESS_LIST.entrySet()) {
            String moduleName = entry.getKey();
            WebMeterInfo.setModuleName(moduleName);
            String alias = WebMeterInfo.getString(WebmeterPropertiesEnum.METER_ALIAS);
            entry.getValue().forEach(item -> this.doBusiness(moduleName, alias, "\u4fdd\u5b58", (JSONObject)item));
        }
    }

    public void doSendBusiness() {
        for (Map.Entry<String, JSONArray> entry : SEND_BUSINESS_LIST.entrySet()) {
            String moduleName = entry.getKey();
            WebMeterInfo.setModuleName(moduleName);
            String alias = WebMeterInfo.getString(WebmeterPropertiesEnum.METER_ALIAS);
            entry.getValue().forEach(item -> this.doBusiness(moduleName, alias, "\u53d1\u9001", (JSONObject)item));
        }
    }

    public void doSendBusiness2() {
        for (Map.Entry<String, JSONArray> entry : SEND_BUSINESS_LIST_2.entrySet()) {
            String moduleName = entry.getKey();
            WebMeterInfo.setModuleName(moduleName);
            String alias = WebMeterInfo.getString(WebmeterPropertiesEnum.METER_ALIAS);
            entry.getValue().forEach(item -> this.doBusiness(moduleName, alias, "\u53d1\u9001(\u4e8c\u7ea7)", (JSONObject)item));
        }
    }

    public void doSendBusiness3() {
        for (Map.Entry<String, JSONArray> entry : SEND_BUSINESS_LIST_3.entrySet()) {
            String moduleName = entry.getKey();
            WebMeterInfo.setModuleName(moduleName);
            String alias = WebMeterInfo.getString(WebmeterPropertiesEnum.METER_ALIAS);
            entry.getValue().forEach(item -> this.doBusiness(moduleName, alias, "\u53d1\u9001(\u4e09\u7ea7)", (JSONObject)item));
        }
    }
}

