/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.util.ExceptionHelper;
import com.aote.webmeter.enums.NotifyTypeEnum;
import com.aote.webmeter.timer.WebMeterTimer;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.IotCommonTools;
import com.aote.webmeter.tools.iot.ctwing.CTWingApiService;
import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="api")
@Component
public class WebMeterService {
    private static final Logger LOGGER = Logger.getLogger(WebMeterService.class);
    @Autowired
    private CTWingApiService ctWingApiService;

    @GET
    @Path(value="reloadProp")
    @Produces(value={"text/plain;charset=UTF-8"})
    public String reloadWebmeterInfo() {
        LOGGER.debug((Object)"\u91cd\u65b0\u52a0\u8f7d\u7269\u8054\u7f51\u8868\u6a21\u5757\u53c2\u6570");
        WebMeterInfo.clear();
        WebMeterInfo.load();
        return "\u547d\u4ee4\u5df2\u5904\u7406\u5b8c\u6210";
    }

    @GET
    @Path(value="reloadTimer")
    @Produces(value={"text/plain;charset=UTF-8"})
    public String reloadTimer() {
        LOGGER.debug((Object)"\u91cd\u65b0\u52a0\u8f7d\u7269\u8054\u7f51\u8868Timer\u6307\u4ee4\u4e1a\u52a1\u5217\u8868");
        WebMeterTimer.clear();
        WebMeterTimer.load();
        return "\u547d\u4ee4\u5df2\u5904\u7406\u5b8c\u6210";
    }

    @POST
    @Path(value="setIotSubscriptions/{moduleName}")
    public Response setIotSubscriptions(@PathParam(value="moduleName") String moduleName, String values) throws IOException {
        LOGGER.debug((Object)"\u8bbe\u7f6eIOT\u5e73\u53f0\u8ba2\u9605\u5730\u5740");
        try {
            WebMeterInfo.setModuleName(moduleName);
            JSONObject obj = new JSONObject(values);
            String url = obj.getString("url");
            IotCommonTools.setIsAep(obj.getInt("isAep"));
            this.ctWingApiService.deleteAllSubscribe();
            JSONObject result = this.ctWingApiService.subscribe(NotifyTypeEnum.DEVICE_DATAS_CHANGED, url);
            Response.ResponseBuilder builder = Response.ok();
            return builder.entity((Object)result).build();
        }
        catch (Exception e) {
            String errorInfo = ExceptionHelper.stackToString((Exception)e);
            return Response.serverError().entity((Object)errorInfo).build();
        }
    }
}

