package com.aote.webmeter.server.tcp;

import com.af.plugins.JsonTools;
import com.aote.logic.LogicServer;
import com.aote.webmeter.enums.MsgTypeEnum;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import java.util.ArrayList;
import java.util.List;

/**
 * TCP服务监听器
 *
 * @author Mrriver
 * @date 2019/2/11
 */
@Deprecated
public class TcpListener implements ServletContextListener {
    /**
     * 配置文件路径
     */
    private static final String PATH = "config/server/TCPListenerConfig.json";
    private List<TcpServer> tcpServers;

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        //读取Tcp配置文件
        if (TcpListener.class.getClassLoader().getResourceAsStream(PATH) != null) {
            JSONArray array = JsonTools.readJsonArrayFile(PATH);
            tcpServers = new ArrayList<>();
            array.forEach(item -> {
                JSONObject params = (JSONObject) item;
                //读取TCP服务名
                String name = params.getString("name");
                //读取Logic名
                String logicName = params.getString("callBackName");
                //读取Tcp端口信息
                JSONArray ports = params.getJSONArray("tcpPort");
                //读取是否需要管道信息
                boolean isHasChannelData = params.getBoolean("isHasChannelData");
                //返回通道信息的Logic名称
                String getChannelDataName;
                if (params.has("getChannelDataName")) {
                    getChannelDataName = params.getString("getChannelDataName");
                } else {
                    getChannelDataName = null;
                }
                LogicServer service = WebApplicationContextUtils.
                        getWebApplicationContext(sce.getServletContext()).getBean(LogicServer.class);
                //读取TCP接收消息格式
                String msgReceiveType = params.getString("msgReceiveType");
                //读取TCP发送消息格式
                String msgSendType = params.getString("msgSendType");
                for (int i = 0; i < ports.length(); i++) {
                    TcpServer tcpServer = new TcpServer(
                            name,
                            logicName,
                            ports.getInt(i),
                            service,
                            MsgTypeEnum.toType(msgReceiveType),
                            MsgTypeEnum.toType(msgSendType),
                            isHasChannelData,
                            getChannelDataName
                    );
                    //放入Tcp服务器数组
                    tcpServers.add(tcpServer);
                }
            });
        }
        for (TcpServer tcpServer : tcpServers) {
            //启动TcpServer
            tcpServer.start();
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        for (TcpServer tcpServer : tcpServers) {
            if (tcpServer != null && tcpServer.isInterrupted()) {
                //销毁TcpServer
                tcpServer.interrupt();
            }
        }
    }
}
