package com.aote.webmeter.enums;

import java.util.stream.Stream;

/**
 * 物联网表服务 IOT参数类型
 * @author Mr.river
 */
public enum WebmeterPropertiesIOTEnum implements PropertiesKeyValueEnum<String> {

    /**
     * 正式的AEP平台
     **/
    //原生AEP平台 产品ID
    AEP_PRODUCT_ID("aepProductId"),
    //原生AEP平台 MasterKey
    AEP_MASTER_KEY("aepMasterKey"),
    //原生AEP平台 AppKey
    AEP_APP_KEY("aepAppKey"),
    //原生AEP平台 App密钥
    AEP_APP_SECRET("aepAppSecret"),

    /**
     * 仅作为对OC/AEP兼容OC模式的兼容
     **/
    //AEP平台应用ApiKey
    AEP_APIKEY("aepAPIKey"),
    //AEP平台应用密钥
    AEP_SECRET("aepSecret"),
    //AEP平台应用回调地址
    AEP_CALLBACK_URL("AEPCallBackUrl"),
    //AEP平台应用自定义对接地址
    AEP_API_URL("aepUrl"),
    //OC平台（集群1）应用ApiKey
    OC_APIKEY("telecomAPIKey"),
    //OC平台（集群1）应用密钥
    OC_SECRET("telecomSecret"),
    //OC平台（集群1）应用回调地址
    OC_CALLBACK_URL("telecomCallBackUrl"),
    //OC平台（集群2）应用ApiKey
    OC2_APIKEY("telecom2APIKey"),
    //OC平台（集群2）应用密钥
    OC2_SECRET("telecom2Secret"),
    //OC平台（集群2）应用自定义对接地址
    OC2_API_URL("telecom2Url"),
    //OC平台（集群2）应用回调地址
    OC2_CALLBACK_URL("telecom2CallBackUrl"),
    //电信平台应用设备厂商ID
    MANUFACTURER_ID("manuFacturerId"),
    //电信平台应用设备厂商名称
    MANUFACTURER_NAME("manuFacturerName"),
    //电信平台应用设备类型
    DEVICE_TYPE("deviceType"),
    //电信平台应用设备型号
    METER_MODEL("meterModel"),

    /**
     * 移动API通用
     **/
    //移动OneNet平台应用objectID
    ONE_NET_OBJECT_ID("onenetObjectID"),
    //移动OneNet平台应用设备objectInstID
    ONE_NET_OBJECT_INST_ID("onenetObjectInstID"),
    //移动OneNet平台应用设备资源ID
    ONE_NET_RES_ID("onenetResID"),
    //移动OneNet平台应用消息加解密密钥
    ONE_NET_ENCODING_AES_KEY("onenetEncodingAESKey"),

    /**
     * 移动老平台API
     **/
    //移动OneNet平台应用APIKey
    ONE_NET_APIKEY("onenetAPIKey"),

    /**
     * 移动新平台API
     **/
    //移动OneNet平台产品ID
    ONE_NET_PRODUCT_ID("onenetProductId"),
    //移动OneNet平台产品APIKey
    ONE_NET_PRODUCT_ACCESS_KEY("onenetProductAccessKey");

    private final String value;

    WebmeterPropertiesIOTEnum(String value) {
        this.value = value;
    }

    public static WebmeterPropertiesIOTEnum toType(String value) {
        return Stream.of(WebmeterPropertiesIOTEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    @Override
    public String getValue(){
        return value;
    }
}
