/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.onenet;

import com.af.plugins.RestAsyncTools;
import com.af.plugins.RestTools;
import com.aote.webmeter.enums.WebmeterPropertiesIOTEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.onenet.OnenetApiService2;
import com.aote.webmeter.tools.iot.onenet.OnenetTools;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OnenetApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnenetApiService.class);
    @Autowired
    private OnenetApiService2 onenetApiService2;
    @Autowired
    private OnenetTools onenetTools;

    public JSONObject createDevice(String imei, String deviceNo) throws InterruptedException {
        Object msg;
        if (this.onenetTools.isNewVersion()) {
            return this.onenetApiService2.createDevice(imei, deviceNo);
        }
        String path = "http://api.heclouds.com:80/devices";
        JSONObject headers = new JSONObject();
        String apiKey = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY);
        headers.put("api-key", (Object)apiKey);
        JSONObject params = new JSONObject();
        params.put("title", (Object)deviceNo);
        params.put("protocol", (Object)"LwM2M");
        params.put("auth_info", (Object)new JSONObject().put(imei, (Object)"000000000000000"));
        JSONObject result = new JSONObject(RestTools.post((String)path, (String)params.toString(), (String)headers.toString()));
        LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}\uff0cresponse: {}\uff0ctype: sync", new Object[]{path, headers, params, result});
        int errno = result.getInt("errno");
        if (errno == 0) {
            msg = result.getJSONObject("data").getString("device_id");
        } else {
            msg = "\u6ce8\u518cIOT\u8bbe\u5907\u5931\u8d25(" + errno + ")\uff1a" + result.getString("error");
            errno = -1;
        }
        return new JSONObject().put("code", errno).put("msg", msg);
    }

    public JSONObject getDevice(String deviceId) {
        String path = "http://api.heclouds.com:80/devices/" + deviceId;
        JSONObject headers = new JSONObject();
        String apiKey = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY);
        headers.put("api-key", (Object)apiKey);
        return new JSONObject(RestTools.get((String)path, (String)headers.toString()));
    }

    public JSONObject deleteDevice(String imei, String deviceId) throws InterruptedException {
        Object msg;
        if (this.onenetTools.isNewVersion()) {
            return this.onenetApiService2.deleteDevice(imei);
        }
        String path = "http://api.heclouds.com:80/devices/" + deviceId;
        JSONObject headers = new JSONObject();
        String apiKey = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY);
        headers.put("api-key", (Object)apiKey);
        JSONObject result = new JSONObject(RestTools.delete((String)path, null, (String)headers.toString()));
        LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}\uff0cresponse: {}\uff0ctype: sync", new Object[]{path, headers, null, result});
        int errno = result.getInt("errno");
        if (errno == 0) {
            msg = "\u6210\u529f";
        } else if (errno == 3) {
            errno = 0;
            msg = "\u5c1d\u8bd5\u5220\u9664\u65f6\u5df2\u4e0d\u5b58\u5728";
        } else {
            errno = -1;
            msg = "\u5220\u9664IOT\u8bbe\u5907\u5931\u8d25\uff1a" + result.getString("error");
        }
        return new JSONObject().put("code", errno).put("msg", msg);
    }

    public JSONObject readDeviceRes(String imei, String timeout) {
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_ID));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_INST_ID));
        params.put("res_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_RES_ID));
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = RestTools.formatURL((String)"http://api.heclouds.com:80/nbiot", (JSONObject)params);
        JSONObject headers = new JSONObject();
        String apiKey = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY);
        headers.put("api-key", (Object)apiKey);
        return new JSONObject(RestTools.get((String)path, (String)headers.toString()));
    }

    public JSONObject writeDeviceRes(String imei, String mode, String timeout, String content) throws InterruptedException {
        if (this.onenetTools.isNewVersion()) {
            return this.onenetApiService2.writeDeviceRes(imei, mode, timeout, content);
        }
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_ID));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_INST_ID));
        params.put("mode", mode == null ? Integer.valueOf(1) : mode);
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = RestTools.formatURL((String)"http://api.heclouds.com:80/nbiot", (JSONObject)params);
        JSONObject headers = new JSONObject();
        String apiKey = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY);
        headers.put("api-key", (Object)apiKey);
        JSONObject body = new JSONObject();
        JSONArray data = new JSONArray();
        JSONObject dataItem = new JSONObject();
        dataItem.put("res_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_RES_ID));
        dataItem.put("type", 1);
        dataItem.put("val", (Object)content);
        data.put((Object)dataItem);
        body.put("data", (Object)data);
        RestAsyncTools.post((String)path, (String)body.toString(), (String)headers.toString());
        LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}\uff0ctype: async", new Object[]{path, headers, body});
        return new JSONObject().put("code", 0);
    }

    public JSONObject sendCommand(String imei, String timeout, String content) throws InterruptedException {
        if (this.onenetTools.isNewVersion()) {
            return this.onenetApiService2.sendCommand(imei, timeout, content);
        }
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_ID));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_INST_ID));
        params.put("res_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_RES_ID));
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = RestTools.formatURL((String)"http://api.heclouds.com:80/nbiot/execute", (JSONObject)params);
        JSONObject headers = new JSONObject();
        String apiKey = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY);
        headers.put("api-key", (Object)apiKey);
        JSONObject body = new JSONObject();
        body.put("args", (Object)content);
        RestAsyncTools.post((String)path, (String)body.toString(), (String)headers.toString());
        LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}", new Object[]{path, headers, content});
        return new JSONObject().put("code", 0);
    }

    public JSONObject subscribe(JSONObject params) {
        String path = RestTools.formatURL((String)"http://api.heclouds.com:80/nbiot/observe", (JSONObject)params);
        JSONObject headers = new JSONObject();
        String apiKey = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY);
        headers.put("api-key", (Object)apiKey);
        String result = RestTools.post((String)path, (String)params.toString(), (String)headers.toString());
        return new JSONObject(result);
    }
}

