package com.aote.webmeter.tools.iot.onenet;

/**
 * 中国移动物联网Onenet平台接口Api
 *
 * @see <a href="https://open.iot.10086.cn/doc/v5/fuse">中国移动物联网开放平台</a>
 * @see <a href="https://open.iot.10086.cn/doc/v5/develop/detail/139">旧版接口</>
 */
public class OnenetApi {
    // 基础地址
    private static final String BASE_URL = "http://api.heclouds.com:80";
    /**
     * 设备接口
     */
    public static final String DEVICE_URL = BASE_URL + "/devices";
    /**
     * 资源接口
     */
    public static final String RESOURCE_URL = BASE_URL + "/nbiot";
    /**
     * 命令接口
     */
    public static final String COMMAND_URL = BASE_URL + "/nbiot/execute";
    /**
     * 订阅接口
     */
    public static final String SUBSCRIPTIONS_URL = BASE_URL + "/nbiot/observe";
}
