package com.aote.webmeter.tools;

import cn.hutool.core.util.HexUtil;

import java.util.Arrays;

public class CRCUtils {


    public static final String bytesToHexString(byte[] bArray) {
        StringBuilder sb = new StringBuilder(bArray.length);
        String sTemp;
        for (byte b : bArray) {
            sTemp = Integer.toHexString(0xFF & b);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public static String getCRC(byte[] bytes) {
        int CRC = 0x0000ffff;
        int POLYNOMIAL = 0x0000a001;

        int i, j;
        for (i = 0; i < bytes.length; i++) {
            CRC ^= ((int) bytes[i] & 0x000000ff);
            for (j = 0; j < 8; j++) {
                if ((CRC & 0x00000001) != 0) {
                    CRC >>= 1;
                    CRC ^= POLYNOMIAL;
                } else {
                    CRC >>= 1;
                }
            }
        }
        CRC = ( (CRC & 0x0000FF00) >> 8) | ( (CRC & 0x000000FF ) << 8);
        String result = Integer.toHexString(CRC);
        if (result.length() < 4) {
            for (int k = 0; k < 4 - result.length(); k++) {
                result = "0" + result;
             }
        }
        return result;
    }

    public static String getCRC2(byte[] bytes) {
//        ModBus 通信协议的 CRC ( 冗余循环校验码含2个字节, 即 16 位二进制数。
//        CRC 码由发送设备计算, 放置于所发送信息帧的尾部。
//        接收信息设备再重新计算所接收信息 (除 CRC 之外的部分）的 CRC,
//        比较计算得到的 CRC 是否与接收到CRC相符, 如果两者不相符, 则认为数据出错。
//
//        1) 预置 1 个 16 位的寄存器为十六进制FFFF(即全为 1) , 称此寄存器为 CRC寄存器。
//        2) 把第一个 8 位二进制数据 (通信信息帧的第一个字节) 与 16 位的 CRC寄存器的低 8 位相异或, 把结果放于 CRC寄存器。
//        3) 把 CRC 寄存器的内容右移一位( 朝低位)用 0 填补最高位, 并检查右移后的移出位。
//        4) 如果移出位为 0, 重复第 3 步 ( 再次右移一位); 如果移出位为 1, CRC 寄存器与多项式A001 ( 1010 0000 0000 0001) 进行异或。
//        5) 重复步骤 3 和步骤 4, 直到右移 8 次,这样整个8位数据全部进行了处理。
//        6) 重复步骤 2 到步骤 5, 进行通信信息帧下一个字节的处理。
//        7) 将该通信信息帧所有字节按上述步骤计算完成后,得到的16位CRC寄存器的高、低字节进行交换。
//        8) 最后得到的 CRC寄存器内容即为 CRC码。

        int CRC = 0x0000ffff;
        int POLYNOMIAL = 0x0000a001;

        int i, j;
        for (i = 0; i < bytes.length; i++) {
            CRC ^= (int) bytes[i];
            for (j = 0; j < 8; j++) {
                if ((CRC & 0x00000001) == 1) {
                    CRC >>= 1;
                    CRC ^= POLYNOMIAL;
                } else {
                    CRC >>= 1;
                }
            }
        }
        //高低位转换，低字节在前，高字节在后
        CRC = ( (CRC & 0x0000FF00) >> 8) | ( (CRC & 0x000000FF ) << 8);
        return Integer.toHexString(CRC);
    }

    public static void main(String[] args) {
//        byte[] key = {0x14, 0x63, 0x68, 0x52, 0x65, (byte) 0x87, 0x53, 0x41};
//        byte[] input = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x34, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
//        System.out.println(Arrays.toString(clacMac(key, input)));

        //17 66 00 A0 29 00 00 00 00 00 00 00 00 00 01 00 00 00 00 00 01 34 11 00 00 00 00 00 00 02 00 01
        //86 A0 83 51 87 55 64 54 81 36 3B AB FE 60
        // A6 F3
        byte[] data2 = {0x17, 0x66, 0x00, (byte) 0xA0, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x34, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x02, 0x00, 0x01, (byte) 0x86, (byte) 0xA0, (byte) 0x83, 0x51, (byte) 0x87, 0x55,
                0x64, 0x54, (byte) 0x81, 0x36, 0x3B, (byte) 0xAB, (byte) 0xFE, 0x60};
        //17 53 19 03 32 30 31 35 30 37 32 33 33 30 33 00 00 00 00 00 17 09 00 00 00 00 00 00 90 51
        byte[] data3 = {0x17, 0x53, 0x19, (byte) 0x03, 0x32, 0x30, 0x31, 0x35, 0x30, 0x37, 0x32, 0x33, 0x33,
                0x30, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
        //17 66 00 A7 24 00 00 00 00 00 00 00 00 00 01 00 00 00 00 00 01 34 11 00 00 00 00 00 00 14 63 68
        //52 65 87 53 41 2C 4B 15 3E
        // D4 AB
        //176600A029000000000123456789010011223344553411000000000000020000000A 2C 1B 38 4A 2A 44 2A 22 21 A6 AE A9
//        byte[] data4 = {0x17, 0x66, 0x00, (byte) 0xA0, 0x29, 0x00, 0x00, 0x00, 0x00, 0x01, 0x23, 0x45, 0x67, (byte) 0x89, 0x01, 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x34, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
//                0x00, 0x0A, (byte) 0x2C, 0x1B, 0x38, 0x4A, 0x2A, 0x44, 0x2A, 0x22, 0x21, (byte) 0xA6, (byte) 0xAE, (byte) 0xA9};

        //176600A02900000000000000000001000000000001341100000000000002 000186A0 83518755645481363BABFE60
        byte[] data4 = {0x17, 0x66, 0x00, (byte) 0xA0, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, (byte) 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x34, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01,
                (byte) 0x86, (byte) 0xA0, (byte) 0x83, 0x51, (byte) 0x87, 0x55, 0x64, 0x54, (byte) 0x81, 0x36, 0x3B, (byte) 0xAB, (byte) 0xFE, (byte) 0x60};
        System.out.println(data4.length);
        System.out.println(getCRC(data4));
        // 低字节在前，高字节在后
        //System.out.println(getCRC2(data4));
        System.out.println(Arrays.toString(HexUtil.decodeHex(getCRC(data4))));

    }
}
