package com.aote.webmeter.timer;

import com.aote.rs.LogicService;
import com.aote.rs.SqlService;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 设备失联统计执行器
 */
@Component
@Profile("prod")
public class SyncDeviceLostContactTimer {

    @Autowired
    private LogicService logicService;

    @Autowired
    private SqlService sqlService;

    private final Logger LOG_MANAGER = LogManager.getLogger(SyncDeviceLostContactTimer.class);

    // 定时执行数据同步
    @Scheduled(cron = "0 1 19 * * ?")
    public void runDataSync() {
        LOG_MANAGER.info("=====开始执行同步设备失联数据任务=====");
        try {
            //获取SQL结果集
            int pageNo = 1;
            int pageSize = 200;
            while (true) {
                JSONArray resultArray = new JSONArray(sqlService.txExecute("getAllDeviceAndMeter", pageNo, pageSize,
                        new JSONObject().put("data", new JSONObject().put("day", 3)).toString()));
                LOG_MANAGER.info("======开始执行业务，第{}批次，本批次共{}条=====", pageNo, resultArray.length());
                if (!resultArray.isEmpty()) {
                    resultArray.forEach((item) -> {
                        //执行Logic
                        runLogic("deviceLostContact", (JSONObject) item);
                    });
                    pageNo++;
                } else {
                    break;
                }
                LOG_MANAGER.info("======第{}批次执行完成=====", pageNo);
            }
            LOG_MANAGER.info("失联设备数据同步完成");
        } catch (Exception e) {
            LOG_MANAGER.error("失联设备数据同步失败", e);
        }
    }

    private void runLogic(String logicName, JSONObject data) {
        try {
            logicService.xtSave(logicName, data.toString());
        } catch (Exception ex) {
            LOG_MANAGER.error("Logic执行失败", ex);
        }
    }
}
