package com.aote.webmeter.exception;

import com.aote.webmeter.enums.ExceptionEnum;

/**
 * 物联网表服务 通用异常类
 *
 * @author Mr.river
 */
public class WebmeterException extends RuntimeException {

    public WebmeterException(ExceptionEnum exceptionEnum) {
        super(
                getErrorMessage(
                        exceptionEnum.getCode(),
                        exceptionEnum.getName(),
                        exceptionEnum.getMessage(),
                        ""
                )
        );
    }

    public WebmeterException(ExceptionEnum exceptionEnum, String remark) {
        super(
                getErrorMessage(
                        exceptionEnum.getCode(),
                        exceptionEnum.getName(),
                        exceptionEnum.getMessage(),
                        remark
                )
        );
    }

    private static String getErrorMessage(String code, String name, String message, String remark) {
        return "\n{\n\t\"errorNo\"：\"" + code + "\"," +
                "\n\t\"name\"：\"" + name + "\"," +
                "\n\t\"message\"：\"" + message + "\"," +
                "\n\t\"remark\"：\"" + remark + "\"\n}";
    }
}
