package com.aote.webmeter.enums;

import java.util.stream.Stream;

/**
 * 物联网表服务 营收版本类型
 *
 * @author Mr.river
 */
public enum SaleVersionEnum {

    //标准版本 - Vue营收
    Vue_V1("Vue-V1"),
    Vue_V2("Vue-V2"),
    Vue_V3("Vue-V3"),
    V4("V4"),
    //银光版本 - 老版营收
    SILVER_LIGHT("SilverLight"),
    SILVER_LIGHT2("SilverLight2");

    private final String value;

    SaleVersionEnum(String value) {
        this.value = value;
    }

    public static SaleVersionEnum toType(String value) {
        return Stream.of(SaleVersionEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
