/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class XXTEATools {
    private static final long DELTA = 2654435769L;
    private static final int MIN_LENGTH = 32;
    private static final char SPECIAL_CHAR = '\u0000';

    public static String Encrypt(String data, String key) {
        return XXTEATools.ToHexString(XXTEATools.TEAEncrypt(XXTEATools.ToLongArray(XXTEATools.PadRight(data).getBytes(StandardCharsets.UTF_8)), XXTEATools.ToLongArray(XXTEATools.PadRight(key).getBytes(StandardCharsets.UTF_8))));
    }

    public static String Decrypt(String data, String key) {
        if (data == null || data.length() < 32) {
            return data;
        }
        byte[] code = XXTEATools.ToByteArray(XXTEATools.TEADecrypt(XXTEATools.ToLongArray(data), XXTEATools.ToLongArray(XXTEATools.PadRight(key).getBytes(StandardCharsets.UTF_8))));
        return new String(code, StandardCharsets.UTF_8);
    }

    private static long[] TEAEncrypt(long[] data, long[] key) {
        int n = data.length;
        if (n < 1) {
            return data;
        }
        long z = data[data.length - 1];
        long y = data[0];
        long sum = 0L;
        long q = 6 + 52 / n;
        while (q-- > 0L) {
            long p;
            long e = (sum += 2654435769L) >> 2 & 3L;
            for (p = 0L; p < (long)(n - 1); ++p) {
                y = data[(int)(p + 1L)];
                int n2 = (int)p;
                long l = data[n2] + ((z >> 5 ^ y << 2) + (y >> 3 ^ z << 4) ^ (sum ^ y) + (key[(int)(p & 3L ^ e)] ^ z));
                data[n2] = l;
                z = l;
            }
            y = data[0];
            int n3 = n - 1;
            long l = data[n3] + ((z >> 5 ^ y << 2) + (y >> 3 ^ z << 4) ^ (sum ^ y) + (key[(int)(p & 3L ^ e)] ^ z));
            data[n3] = l;
            z = l;
        }
        return data;
    }

    private static long[] TEADecrypt(long[] data, long[] key) {
        int n = data.length;
        if (n < 1) {
            return data;
        }
        long z = data[data.length - 1];
        long y = data[0];
        long sum = 0L;
        long q = 6 + 52 / n;
        for (sum = q * 2654435769L; sum != 0L; sum -= 2654435769L) {
            long p;
            long e = sum >> 2 & 3L;
            for (p = (long)(n - 1); p > 0L; --p) {
                z = data[(int)(p - 1L)];
                int n2 = (int)p;
                long l = data[n2] - ((z >> 5 ^ y << 2) + (y >> 3 ^ z << 4) ^ (sum ^ y) + (key[(int)(p & 3L ^ e)] ^ z));
                data[n2] = l;
                y = l;
            }
            z = data[n - 1];
            y = data[0] = data[0] - ((z >> 5 ^ y << 2) + (y >> 3 ^ z << 4) ^ (sum ^ y) + (key[(int)(p & 3L ^ e)] ^ z));
        }
        return data;
    }

    private static long[] ToLongArray(byte[] data) {
        int n = (data.length % 8 == 0 ? 0 : 1) + data.length / 8;
        long[] result = new long[n];
        for (int i = 0; i < n - 1; ++i) {
            result[i] = XXTEATools.bytes2long(data, i * 8);
        }
        byte[] buffer = new byte[8];
        int i = 0;
        for (int j = (n - 1) * 8; j < data.length; ++j) {
            buffer[i] = data[j];
            ++i;
        }
        result[n - 1] = XXTEATools.bytes2long(buffer, 0);
        return result;
    }

    private static byte[] ToByteArray(long[] data) {
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (int i = 0; i < data.length; ++i) {
            byte[] bs = XXTEATools.long2bytes(data[i]);
            for (int j = 0; j < 8; ++j) {
                result.add(bs[j]);
            }
        }
        while ((Byte)result.get(result.size() - 1) == 0) {
            result.remove(result.size() - 1);
        }
        byte[] ret = new byte[result.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Byte)result.get(i);
        }
        return ret;
    }

    public static byte[] long2bytes(long num) {
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(num);
        return buffer.array();
    }

    public static long bytes2long(byte[] b, int index) {
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(b, index, 8);
        return buffer.getLong(0);
    }

    private static String ToHexString(long[] data) {
        StringBuilder sb = new StringBuilder();
        for (long datum : data) {
            sb.append(XXTEATools.PadLeft(Long.toHexString(datum)));
        }
        return sb.toString();
    }

    private static long[] ToLongArray(String data) {
        int len = data.length() / 16;
        long[] result = new long[len];
        for (int i = 0; i < len; ++i) {
            result[i] = new BigInteger(data.substring(i * 16, i * 16 + 16), 16).longValue();
        }
        return result;
    }

    private static String PadRight(String source) {
        StringBuilder sourceBuilder = new StringBuilder(source);
        while (sourceBuilder.length() < 32) {
            sourceBuilder.append('\u0000');
        }
        source = sourceBuilder.toString();
        return source;
    }

    private static String PadLeft(String source) {
        StringBuilder sourceBuilder = new StringBuilder(source);
        while (sourceBuilder.length() < 16) {
            sourceBuilder.insert(0, '0');
        }
        source = sourceBuilder.toString();
        return source;
    }
}

